/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.nio;

import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.CloseableObject;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.transport.tcp.impl.TcpConnectionParameters;
import org.opcfoundation.ua.transport.tcp.nio.Channel;
import org.opcfoundation.ua.transport.tcp.nio.SecureInputMessageBuilder;
import org.opcfoundation.ua.utils.AbstractState;
import org.opcfoundation.ua.utils.IncubationQueue;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.StateListener;
import org.opcfoundation.ua.utils.asyncsocket.SocketState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerConnection
extends AbstractState<CloseableObjectState, ServiceResultException>
implements ServerConnection,
CloseableObject {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerConnection.class);
    int agreedProtocolVersion = 0;
    SecurityConfiguration securityConfiguration;
    StateListener<SocketState> socketListener;
    TcpConnectionParameters ctx = new TcpConnectionParameters();
    SecureInputMessageBuilder secureMessageBuilder;
    Map<Integer, ServerSecureChannel> secureChannels = new ConcurrentHashMap<Integer, ServerSecureChannel>();
    CopyOnWriteArrayList<ServerConnection.SecureChannelListener> secureChannelListeners = new CopyOnWriteArrayList();
    IncubationQueue<ByteBuffer> chunkIncubator = new IncubationQueue(true);
    CopyOnWriteArrayList<Channel.ChannelListener> channelListeners = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<IConnectionListener> connectionListeners = new CopyOnWriteArrayList();

    protected AbstractServerConnection() {
        super(CloseableObjectState.Closed);
    }

    protected abstract CertificateValidator getRemoteCertificateValidator();

    protected abstract int sendAsymmSecureMessage(AsyncWrite var1, SecurityConfiguration var2, int var3, int var4, AtomicInteger var5) throws ServiceResultException;

    protected abstract void sendSecureMessage(AsyncWrite var1, SecurityToken var2, int var3, int var4, AtomicInteger var5);

    @Override
    protected void setError(UnsignedInteger unsignedInteger) {
        this.setError(new StatusCode(unsignedInteger));
    }

    @Override
    protected void setError(StatusCode statusCode) {
        this.setError(new ServiceResultException(statusCode));
    }

    @Override
    protected synchronized void setError(ServiceResultException serviceResultException) {
        if (this.hasError()) {
            return;
        }
        super.setError(serviceResultException);
        this.close();
    }

    @Override
    protected void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Open) {
            for (IConnectionListener object : this.connectionListeners) {
                object.onOpen();
            }
        }
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError);
            for (IConnectionListener iConnectionListener : this.connectionListeners) {
                iConnectionListener.onClosed(serviceResultException);
            }
        }
    }

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }

    @Override
    public void getSecureChannels(Collection<ServerSecureChannel> collection) {
        collection.addAll(this.secureChannels.values());
    }

    @Override
    public void addSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.secureChannelListeners.add(secureChannelListener);
    }

    @Override
    public void removeSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.secureChannelListeners.remove(secureChannelListener);
    }

    protected void fireSecureChannelAttached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.secureChannelListeners) {
            secureChannelListener.onSecureChannelAttached(this, serverSecureChannel);
        }
    }

    protected void fireSecureChannelDetached(ServerSecureChannel serverSecureChannel) {
        for (ServerConnection.SecureChannelListener secureChannelListener : this.secureChannelListeners) {
            secureChannelListener.onSecureChannelDetached(this, serverSecureChannel);
        }
    }

    public String getConnectURL() {
        return this.ctx.endpointUrl;
    }

    public Certificate getRemoteCertificate() {
        return this.securityConfiguration.getReceiverCertificate();
    }

    public void addChannelListener(Channel.ChannelListener channelListener) {
        this.channelListeners.add(channelListener);
    }

    public void removeChannelListener(Channel.ChannelListener channelListener) {
        this.channelListeners.remove(channelListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.add(iConnectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.remove(iConnectionListener);
    }

    public String toString() {
        CloseableObjectState closeableObjectState = (CloseableObjectState)((Object)this.getState());
        return "Connection (state=" + (Object)((Object)closeableObjectState) + ", addr=" + this.getRemoteAddress() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CloseableObject close() {
        try {
            this.setState(CloseableObjectState.Closing);
        }
        finally {
            this.setState(CloseableObjectState.Closed);
        }
        return this;
    }
}

