/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.tcp.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ChannelSecurityToken;
import org.opcfoundation.ua.core.CloseSecureChannelRequest;
import org.opcfoundation.ua.core.EncodeableSerializer;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.OpenSecureChannelRequest;
import org.opcfoundation.ua.core.OpenSecureChannelResponse;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityConfiguration;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.impl.Acknowledge;
import org.opcfoundation.ua.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import org.opcfoundation.ua.transport.tcp.impl.ChunkAsymmEncryptSigner;
import org.opcfoundation.ua.transport.tcp.impl.ChunkFactory;
import org.opcfoundation.ua.transport.tcp.impl.ChunkSymmDecryptVerifier;
import org.opcfoundation.ua.transport.tcp.impl.ChunkSymmEncryptSigner;
import org.opcfoundation.ua.transport.tcp.impl.ChunkUtils;
import org.opcfoundation.ua.transport.tcp.impl.ErrorMessage;
import org.opcfoundation.ua.transport.tcp.impl.Hello;
import org.opcfoundation.ua.transport.tcp.impl.SecurityToken;
import org.opcfoundation.ua.transport.tcp.io.IConnection;
import org.opcfoundation.ua.transport.tcp.io.OpcTcpSettings;
import org.opcfoundation.ua.transport.tcp.io.SequenceNumber;
import org.opcfoundation.ua.transport.tcp.io.TcpConnectionLimits;
import org.opcfoundation.ua.transport.tcp.io.TcpQuotas;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferArrayReadable;
import org.opcfoundation.ua.utils.bytebuffer.ByteBufferArrayWriteable2;
import org.opcfoundation.ua.utils.bytebuffer.InputStreamReadable;
import org.opcfoundation.ua.utils.bytebuffer.OutputStreamWriteable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements IConnection {
    static Logger logger = LoggerFactory.getLogger(TcpConnection.class);
    EncodeType encodeType;
    PrivKey clientPrivateKey;
    Cert clientCertificate;
    Cert serverCertificate;
    EndpointConfiguration endpointConfiguration;
    EndpointDescription endpointDescription;
    IEncodeableSerializer serializer = EncodeableSerializer.getInstance();
    CertificateValidator certificateValidator;
    InetSocketAddress addr;
    TcpConnectionLimits limits;
    TcpQuotas quotas = TcpQuotas.DEFAULT_CLIENT_QUOTA;
    EnumSet<OpcTcpSettings.Flag> flags = EnumSet.noneOf(OpcTcpSettings.Flag.class);
    int handshakeTimeout = 60000;
    SecurityConfiguration securityConfiguration;
    final List<SecurityToken> tokens = new CopyOnWriteArrayList<SecurityToken>();
    final Map<Integer, SecurityToken> activeTokenIdMap = new ConcurrentHashMap<Integer, SecurityToken>();
    final Map<Integer, byte[]> clientNonces = new ConcurrentHashMap<Integer, byte[]>();
    final Map<Integer, SequenceNumber> sequenceNumbers = new ConcurrentHashMap<Integer, SequenceNumber>();
    private Socket socket = null;
    int protocolVersion;
    OutputStreamWriteable out;
    ReentrantLock lock = new ReentrantLock();
    ReadThread thread;
    EncoderContext ctx;
    List<IConnection.IMessageListener> listeners = new CopyOnWriteArrayList<IConnection.IMessageListener>();
    List<IConnectionListener> connectionListeners = new CopyOnWriteArrayList<IConnectionListener>();
    private static int receiveBufferSize = 0;
    private static int sendBufferSize = 0;

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    public static int getReceiveBufferSize() {
        return receiveBufferSize;
    }

    public static void setReceiveBufferSize(int n) {
        receiveBufferSize = n;
    }

    public static int getSendBufferSize() {
        return sendBufferSize;
    }

    public static void setSendBufferSize(int n) {
        sendBufferSize = n;
    }

    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        try {
            URI uRI = new URI(string);
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(uRI);
            this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, (Throwable)uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.lock.lock();
        try {
            this.addr = inetSocketAddress;
            this.endpointConfiguration = transportChannelSettings.getConfiguration().clone();
            this.endpointDescription = transportChannelSettings.getDescription().clone();
            this.certificateValidator = transportChannelSettings.getOpctcpSettings().getCertificateValidator();
            this.ctx = encoderContext;
            this.clientCertificate = transportChannelSettings.getOpctcpSettings().getClientCertificate();
            this.serverCertificate = transportChannelSettings.getServerCertificate();
            this.clientPrivateKey = transportChannelSettings.getOpctcpSettings().getPrivKey();
            this.encodeType = EncodeType.Binary;
            if (this.endpointConfiguration.getUseBinaryEncoding() != null && !this.endpointConfiguration.getUseBinaryEncoding().booleanValue()) {
                this.encodeType = EncodeType.Xml;
            }
            this.flags = transportChannelSettings.getOpctcpSettings().getFlags();
            KeyPair keyPair = this.clientCertificate == null ? null : new KeyPair(this.clientCertificate, this.clientPrivateKey);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.endpointDescription.getSecurityPolicyUri());
            SecurityMode securityMode = new SecurityMode(securityPolicy, this.endpointDescription.getSecurityMode());
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, this.serverCertificate);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ServiceResultException {
        this.lock.lock();
        try {
            Socket socket = this.getSocket();
            if (socket != null && socket.isConnected()) {
                return;
            }
            try {
                logger.info("{} Connecting", (Object)this.addr);
                int n = this.handshakeTimeout;
                socket = new Socket();
                if (receiveBufferSize > 0) {
                    socket.setReceiveBufferSize(receiveBufferSize);
                }
                if (sendBufferSize > 0) {
                    socket.setSendBufferSize(sendBufferSize);
                }
                this.setSocket(socket);
                if (n == 0) {
                    socket.connect(this.addr);
                } else {
                    socket.setSoTimeout(this.handshakeTimeout);
                    socket.connect(this.addr, n);
                }
            }
            catch (ConnectException connectException) {
                logger.info(this.addr + " Connect failed", (Throwable)connectException);
                throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)connectException);
            }
            catch (IOException iOException) {
                logger.info(this.addr + " Connect failed", (Throwable)iOException);
                throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
            }
            logger.debug("{} Socket connected", (Object)this.addr);
            try {
                OutputStreamWriteable outputStreamWriteable = new OutputStreamWriteable(socket.getOutputStream());
                outputStreamWriteable.order(ByteOrder.LITTLE_ENDIAN);
                InputStreamReadable inputStreamReadable = new InputStreamReadable(socket.getInputStream(), Long.MAX_VALUE);
                inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                int n = Math.min(this.endpointConfiguration.getMaxMessageSize() != null ? this.endpointConfiguration.getMaxMessageSize() : Integer.MAX_VALUE, this.quotas.maxMessageSize);
                this.ctx.setMaxMessageSize(n);
                this.ctx.setMaxArrayLength(this.endpointConfiguration.getMaxArrayLength() != null ? this.endpointConfiguration.getMaxArrayLength() : 0);
                this.ctx.setMaxStringLength(this.endpointConfiguration.getMaxStringLength() != null ? this.endpointConfiguration.getMaxStringLength() : 0);
                this.ctx.setMaxByteStringLength(this.endpointConfiguration.getMaxByteStringLength() != null ? this.endpointConfiguration.getMaxByteStringLength() : 0);
                BinaryDecoder binaryDecoder = new BinaryDecoder(inputStreamReadable);
                binaryDecoder.setEncoderContext(this.ctx);
                BinaryEncoder binaryEncoder = new BinaryEncoder(outputStreamWriteable);
                binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
                binaryEncoder.setEncoderContext(this.ctx);
                EncoderCalc encoderCalc = new EncoderCalc();
                encoderCalc.setEncoderContext(this.ctx);
                Hello hello = new Hello();
                hello.setEndpointUrl(this.endpointDescription.getEndpointUrl());
                hello.setMaxChunkCount(UnsignedInteger.valueOf(this.endpointConfiguration.getMaxBufferSize() == null ? 65535L : (long)this.endpointConfiguration.getMaxBufferSize().intValue()));
                hello.setMaxMessageSize(UnsignedInteger.valueOf(n));
                hello.setReceiveBufferSize(UnsignedInteger.valueOf(this.quotas.maxBufferSize));
                hello.setSendBufferSize(UnsignedInteger.valueOf(this.quotas.maxBufferSize));
                hello.setProtocolVersion(UnsignedInteger.valueOf(0L));
                if (this.limits != null) {
                    hello.setProtocolVersion(UnsignedInteger.valueOf(this.protocolVersion));
                    hello.setMaxChunkCount(UnsignedInteger.valueOf(this.limits.maxRecvChunkCount));
                    hello.setMaxMessageSize(UnsignedInteger.valueOf(this.limits.maxRecvMessageSize));
                    hello.setSendBufferSize(UnsignedInteger.valueOf(this.limits.maxSendBufferSize));
                    hello.setReceiveBufferSize(UnsignedInteger.valueOf(this.limits.maxRecvBufferSize));
                }
                outputStreamWriteable.putInt(1179403592);
                encoderCalc.putEncodeable(null, Hello.class, hello);
                int n2 = encoderCalc.getAndReset() + 8;
                outputStreamWriteable.putInt(n2);
                binaryEncoder.putEncodeable(null, Hello.class, hello);
                outputStreamWriteable.flush();
                int n3 = -1;
                while (n3 == -1) {
                    try {
                        n3 = inputStreamReadable.getInt();
                    }
                    catch (EOFException eOFException) {
                        n3 = inputStreamReadable.getInt();
                    }
                }
                n2 = inputStreamReadable.getInt();
                if (n2 < 8 || n2 > 4096) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
                }
                if (n3 == 1179800133) {
                    binaryDecoder.getEncoderContext().setMaxStringLength(4096);
                    ErrorMessage errorMessage = binaryDecoder.getEncodeable(null, ErrorMessage.class);
                    throw new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                }
                if (n3 != 1179337537) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n3 + ", expected " + 1179337537);
                }
                Acknowledge acknowledge = binaryDecoder.getEncodeable(null, Acknowledge.class);
                if (acknowledge.getProtocolVersion().intValue() < hello.getProtocolVersion().intValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_ProtocolVersionUnsupported, "Version " + hello.getProtocolVersion().intValue() + " requested, got " + acknowledge.getProtocolVersion());
                }
                this.protocolVersion = Math.min(hello.getProtocolVersion().intValue(), acknowledge.getProtocolVersion().intValue());
                if (acknowledge.getMaxMessageSize().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxMessageSize(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getMaxChunkCount().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxChunkCount(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getReceiveBufferSize().longValue() > hello.getReceiveBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.ReceiveBufferSize > Hello.ReceiveBufferSize");
                }
                if (acknowledge.getReceiveBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server recv buffer size < 8192");
                }
                if (acknowledge.getSendBufferSize().longValue() > hello.getSendBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.SendBufferSize > Hello.SendBufferSize");
                }
                if (acknowledge.getSendBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server send buffer size < 8192");
                }
                this.limits = new TcpConnectionLimits();
                this.limits.maxSendBufferSize = (int)Math.min(acknowledge.getSendBufferSize().longValue(), Integer.MAX_VALUE);
                this.limits.maxRecvBufferSize = (int)Math.min(acknowledge.getReceiveBufferSize().longValue(), Integer.MAX_VALUE);
                this.limits.maxSendChunkCount = (int)Math.min(acknowledge.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.limits.maxRecvChunkCount = (int)Math.min(hello.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.limits.maxSendMessageSize = (int)Math.min(acknowledge.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                this.limits.maxRecvMessageSize = (int)Math.min(hello.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                socket.setSoTimeout(0);
                socket.setKeepAlive(true);
                logger.info("{} Connected", (Object)this.addr);
                for (IConnectionListener iConnectionListener : this.connectionListeners) {
                    iConnectionListener.onOpen();
                }
                logger.debug("Creating ReadThread");
                this.thread = new ReadThread(socket, binaryDecoder.getEncoderContext());
                this.thread.start();
                this.ctx = binaryEncoder.getEncoderContext();
                this.out = outputStreamWriteable;
            }
            catch (IOException iOException) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)iOException);
                throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)serviceResultException);
                throw serviceResultException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        ReadThread readThread = this.thread;
        if (readThread != null) {
            readThread.closing = true;
        }
        this.close(new ServiceResultException(StatusCodes.Bad_CommunicationError, "Socket closed by the user"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(ServiceResultException serviceResultException) {
        this.lock.lock();
        try {
            Socket socket = this.getSocket();
            if (socket == null || !socket.isConnected() || socket.isClosed()) {
                return;
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.warn(this.addr + " Close error", (Throwable)iOException);
            }
            this.setSocket(null);
            this.clientNonces.clear();
            logger.info(this.addr + " Closed");
        }
        finally {
            this.lock.unlock();
        }
        for (IConnectionListener iConnectionListener : this.connectionListeners) {
            iConnectionListener.onClosed(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket getSocket() {
        this.lock.lock();
        try {
            Socket socket = this.socket;
            return socket;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws ServiceResultException {
        this.lock.lock();
        try {
            Socket socket = this.getSocket();
            if (socket != null && socket.isConnected() && !socket.isClosed()) {
                this.close();
            }
            this.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public EndpointDescription getEndpointDescription() {
        return this.endpointDescription;
    }

    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.lock.lock();
        try {
            this.close();
            this.clientPrivateKey = null;
            this.clientCertificate = null;
            this.serverCertificate = null;
            this.endpointConfiguration = null;
            this.endpointDescription = null;
            this.serializer = null;
            this.certificateValidator = null;
            this.setSocket(null);
            this.ctx = null;
            this.out = null;
            this.quotas = null;
            this.limits = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ServiceRequest serviceRequest, int n, int n2) throws ServiceResultException {
        block16: {
            if (serviceRequest == null) {
                logger.warn("sendRequest: request=null");
            }
            EncoderCalc encoderCalc = null;
            boolean bl = serviceRequest instanceof OpenSecureChannelRequest;
            Socket socket = this.getSocket();
            logger.debug("sendRequest: socket={}", (Object)socket);
            try {
                ByteBuffer[] byteBufferArray;
                ByteBuffer[] byteBufferArray2;
                MessageBuffers messageBuffers;
                if (socket == null || !socket.isConnected() || socket.isClosed()) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerNotConnected);
                }
                logger.debug("sendRequest: {} Sending Request rid:{}", (Object)n, (Object)n2);
                logger.trace("sendrequest: request={}", (Object)serviceRequest);
                SecurityToken securityToken = null;
                encoderCalc = new EncoderCalc();
                encoderCalc.setEncoderContext(this.ctx);
                encoderCalc.putMessage(serviceRequest);
                int n3 = encoderCalc.getAndReset();
                if (n != 0) {
                    securityToken = this.getSecurityTokenToUse(n);
                }
                logger.debug("sendRequest: token={}", (Object)securityToken);
                SecurityMode securityMode = this.getSecurityMode(bl, serviceRequest, securityToken);
                int n4 = securityToken != null ? securityToken.getSecurityPolicy().getEncryptionKeySize() : 0;
                logger.debug("sendRequest: keySize={}", (Object)n4);
                ChunkFactory chunkFactory = this.getChunkFactory(bl, securityMode, n4);
                if (chunkFactory == null || (messageBuffers = this.encodeMessage(chunkFactory, n3, serviceRequest)) == null || !((byteBufferArray2 = messageBuffers.getChunks()) != null & (byteBufferArray = messageBuffers.getPlaintexts()) != null)) break block16;
                try {
                    this.lock.lock();
                    try {
                        if (bl) {
                            byte[] byArray = ((OpenSecureChannelRequest)serviceRequest).getClientNonce();
                            this.clientNonces.put(n2, byArray);
                            for (int i = 0; i < byteBufferArray2.length; ++i) {
                                boolean bl2 = i == byteBufferArray2.length - 1;
                                this.sendAsymmChunk(n, n2, securityMode, byteBufferArray2[i], byteBufferArray[i], bl2);
                                byteBufferArray[i] = null;
                                byteBufferArray2[i] = null;
                            }
                        } else {
                            this.activeTokenIdMap.put(n, securityToken);
                            SequenceNumber sequenceNumber = this.sequenceNumbers.get(n);
                            for (int i = 0; i < byteBufferArray2.length; ++i) {
                                ByteBuffer byteBuffer = byteBufferArray2[i];
                                ByteBuffer byteBuffer2 = byteBufferArray[i];
                                boolean bl3 = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
                                int n5 = 1128747853;
                                if (bl3) {
                                    n5 = 1179079501;
                                }
                                if (serviceRequest instanceof CloseSecureChannelRequest) {
                                    n5 = 1179601987;
                                }
                                this.sendSymmChunk(n2, securityToken, sequenceNumber, byteBuffer, byteBuffer2, n5);
                                byteBufferArray[i] = null;
                                byteBufferArray2[i] = null;
                            }
                        }
                        this.out.flush();
                    }
                    catch (IOException iOException) {
                        this.clientNonces.remove(n2);
                        logger.info(this.addr + " Connect failed", (Throwable)iOException);
                        this.close();
                        throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn(String.format("sendRequest %s failed: socket=%s, asymm=%s, calc=%s", serviceRequest.getClass().getName(), socket, bl, encoderCalc), (Throwable)runtimeException);
                throw runtimeException;
            }
        }
    }

    private void sendSymmChunk(int n, SecurityToken securityToken, SequenceNumber sequenceNumber, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) throws ServiceResultException, IOException {
        byteBuffer.rewind();
        byteBuffer.putInt(n2);
        byteBuffer.position(8);
        byteBuffer.putInt(securityToken.getSecureChannelId());
        byteBuffer.putInt(securityToken.getTokenId());
        int n3 = sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n3);
        byteBuffer.putInt(n);
        try {
            new ChunkSymmEncryptSigner(byteBuffer, byteBuffer2, securityToken).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.out.put(byteBuffer);
    }

    private void sendAsymmChunk(int n, int n2, SecurityMode securityMode, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ServiceResultException, IOException {
        SequenceNumber sequenceNumber;
        byteBuffer.rewind();
        byteBuffer.putInt(bl ? 1179537487 : 1129205839);
        byteBuffer.position(8);
        byteBuffer.putInt(n);
        byte[] byArray = securityMode.getSecurityPolicy().getEncodedPolicyUri();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byArray = this.securityConfiguration.getEncodedLocalCertificate();
        byteBuffer.putInt(byArray == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putInt((byArray = this.securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        int n3 = (sequenceNumber = this.sequenceNumbers.get(n)) == null ? 1 : sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n3);
        byteBuffer.putInt(n2);
        logger.debug("SecureChannelId={} SequenceNumber={}, RequestId={}", new Object[]{n, n3, n2});
        try {
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, this.securityConfiguration).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.out.put(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageBuffers encodeMessage(ChunkFactory chunkFactory, int n, IEncodeable iEncodeable) throws ServiceResultException {
        int n2;
        int n3 = (n + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
        this.lock.lock();
        try {
            if (this.limits == null) {
                MessageBuffers messageBuffers = null;
                return messageBuffers;
            }
            n2 = this.limits.maxSendChunkCount;
        }
        finally {
            this.lock.unlock();
        }
        if (n2 != 0 && n3 > n2) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        int n4 = n;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n3];
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            byteBufferArray[i] = chunkFactory.allocate(n4);
            byteBufferArray2[i] = chunkFactory.expandToCompleteChunk(byteBufferArray[i]);
            n4 -= byteBufferArray[i].remaining();
        }
        assert (n4 == 0);
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, int n) {
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        EncoderCalc encoderCalc = new EncoderCalc();
        encoderCalc.setEncoderContext(this.ctx);
        encoderCalc.putMessage(iEncodeable);
        if (this.ctx.maxMessageSize != 0 && encoderCalc.getLength() > this.ctx.maxMessageSize) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxMessageSize " + this.ctx.maxMessageSize + " < " + n);
            logger.warn("encodeMessage: failed", (Throwable)encodingException);
            throw encodingException;
        }
        BinaryEncoder binaryEncoder = new BinaryEncoder(byteBufferArrayWriteable2);
        binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
        binaryEncoder.setEncoderContext(this.ctx);
        binaryEncoder.putMessage(iEncodeable);
        return new MessageBuffers(byteBufferArray2, byteBufferArray);
    }

    private SecurityMode getSecurityMode(boolean bl, ServiceRequest serviceRequest, SecurityToken securityToken) {
        SecurityPolicy securityPolicy;
        MessageSecurityMode messageSecurityMode;
        if (bl) {
            messageSecurityMode = ((OpenSecureChannelRequest)serviceRequest).getSecurityMode();
            securityPolicy = this.securityConfiguration.getSecurityMode().getSecurityPolicy();
        } else {
            messageSecurityMode = securityToken.getMessageSecurityMode();
            securityPolicy = securityToken.getSecurityPolicy();
        }
        return new SecurityMode(securityPolicy, messageSecurityMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkFactory getChunkFactory(boolean bl, SecurityMode securityMode, int n) throws ServiceResultException {
        int n2;
        MessageSecurityMode messageSecurityMode = securityMode.getMessageSecurityMode();
        this.lock.lock();
        try {
            if (this.limits == null) {
                ChunkFactory chunkFactory = null;
                return chunkFactory;
            }
            n2 = this.limits.maxSendBufferSize;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            return new ChunkFactory.AsymmMsgChunkFactory(n2, this.securityConfiguration);
        }
        SecurityPolicy securityPolicy = securityMode.getSecurityPolicy();
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecurityAlgorithm securityAlgorithm2 = securityPolicy.getSymmetricSignatureAlgorithm();
        int n3 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
        int n4 = CryptoUtil.getSignatureSize(securityAlgorithm2, null);
        return new ChunkFactory(n2, 8, 8, 8, n4, n3, messageSecurityMode, n);
    }

    private SecurityToken getSecurityTokenToUse(int n) throws ServiceResultException {
        this.pruneInvalidTokens();
        SecurityToken securityToken = null;
        logger.debug("tokens={}", this.tokens);
        for (SecurityToken securityToken2 : this.tokens) {
            if (securityToken2.getSecureChannelId() != n || securityToken != null && securityToken.getCreationTime() >= securityToken2.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        logger.debug("getSecurityTokenToUse={}", securityToken);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "All security tokens have expired");
        }
        return securityToken;
    }

    private void pruneInvalidTokens() {
        logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.tokens.size(), this.tokens);
        for (SecurityToken securityToken : this.tokens) {
            if (securityToken.isValid()) continue;
            this.tokens.remove(securityToken);
        }
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(int n) {
        this.handshakeTimeout = n;
    }

    @Override
    public void addMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.add(iMessageListener);
    }

    @Override
    public void removeMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.remove(iMessageListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.add(iConnectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.remove(iConnectionListener);
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public SocketAddress getSocketAddress() {
        return this.addr;
    }

    class ReadThread
    extends Thread {
        Socket s;
        EncoderContext ctx;
        ServiceResultException closeError;
        boolean closing;

        ReadThread(Socket socket, EncoderContext encoderContext) {
            super("TcpConnection/Read");
            this.closeError = null;
            this.closing = false;
            this.setDaemon(true);
            this.s = socket;
            this.ctx = encoderContext;
        }

        @Override
        public void run() {
            block46: {
                try {
                    InputStreamReadable inputStreamReadable = new InputStreamReadable(this.s.getInputStream(), Long.MAX_VALUE);
                    inputStreamReadable.order(ByteOrder.LITTLE_ENDIAN);
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(256);
                    while (this.s == TcpConnection.this.getSocket()) {
                        Object t;
                        int n;
                        int n2;
                        block47: {
                            int n3;
                            Object object;
                            Object object2;
                            Iterator<IConnection.IMessageListener> iterator;
                            arrayList.clear();
                            int n4 = 0;
                            int n5 = 0;
                            int n6 = 0;
                            n2 = 0;
                            n = 0;
                            do {
                                Object object3;
                                Object object4;
                                if (n5 > TcpConnection.this.limits.maxRecvChunkCount) {
                                    this.closeError = new ServiceResultException("Recv chunk count exceeded (max = " + n5 + ")");
                                    logger.warn("{} Recv chunk count exceeded (max = {})", (Object)TcpConnection.this.addr, (Object)n5);
                                    break block46;
                                }
                                int n7 = inputStreamReadable.getInt();
                                int n8 = n7 & 0xFFFFFF;
                                n6 = n7 & 0xFF000000;
                                if (n5 == 0) {
                                    n4 = n8;
                                } else if (n8 != n4) {
                                    this.closeError = new ServiceResultException("Error, message type changed between chunks");
                                    logger.warn("{} Error, message type changed between chunks", (Object)TcpConnection.this.addr);
                                    break block46;
                                }
                                if (n8 != 5132367 && n8 != 4674381 && n7 != 1179800133) {
                                    this.closeError = new ServiceResultException("Error, unknown message type " + String.format("0x%08x", n7));
                                    logger.warn("{} Error, unknown message type {}", (Object)TcpConnection.this.addr, (Object)String.format("0x%08x", n7));
                                    break block46;
                                }
                                int n9 = inputStreamReadable.getInt();
                                if (n9 > TcpConnection.this.limits.maxRecvBufferSize) {
                                    this.closeError = new ServiceResultException("Error, chunk too large (max = " + TcpConnection.this.limits.maxRecvBufferSize + ")");
                                    logger.warn("{} Error, chunk too large (max = {})", (Object)TcpConnection.this.addr, (Object)TcpConnection.this.limits.maxRecvBufferSize);
                                    break block46;
                                }
                                iterator = ByteBuffer.allocate(n9);
                                ((ByteBuffer)((Object)iterator)).order(ByteOrder.LITTLE_ENDIAN);
                                ((ByteBuffer)((Object)iterator)).putInt(n7);
                                ((ByteBuffer)((Object)iterator)).putInt(n9);
                                inputStreamReadable.get((ByteBuffer)((Object)iterator), n9 - 8);
                                if (n7 == 1179800133) {
                                    ((ByteBuffer)((Object)iterator)).position(8);
                                    BinaryDecoder binaryDecoder = new BinaryDecoder((ByteBuffer)((Object)iterator));
                                    binaryDecoder.setEncoderContext(this.ctx);
                                    ErrorMessage errorMessage = binaryDecoder.getEncodeable(null, ErrorMessage.class);
                                    this.closeError = object2 = new ServiceResultException(errorMessage.getError(), errorMessage.getReason());
                                    logger.warn(this.s.getRemoteSocketAddress() + " Error", (Throwable)object2);
                                    break block46;
                                }
                                int n10 = ChunkUtils.getSecureChannelId((ByteBuffer)((Object)iterator));
                                if (n5 == 0) {
                                    n = n10;
                                } else if (n != n10) {
                                    this.closeError = new ServiceResultException("Error, SecureChannelId mismatch");
                                    logger.warn("{} Error, SecureChannelId mismatch", (Object)TcpConnection.this.addr);
                                    break block46;
                                }
                                if (n4 == 5132367) {
                                    try {
                                        Object object5;
                                        String string = ChunkUtils.getSecurityPolicyUri((ByteBuffer)((Object)iterator));
                                        object2 = SecurityPolicy.getSecurityPolicy(string);
                                        object4 = ChunkUtils.getByteString((ByteBuffer)((Object)iterator));
                                        object3 = ChunkUtils.getByteString((ByteBuffer)((Object)iterator));
                                        if (object2 != TcpConnection.this.securityConfiguration.getSecurityPolicy()) {
                                            this.closeError = new ServiceResultException("Error, unexpected security policy in OpenSecureChannelResponse");
                                            logger.warn("{} Error, unexpected security policy in OpenSecureChannelResponse", (Object)TcpConnection.this.addr);
                                            break block46;
                                        }
                                        if (TcpConnection.this.securityConfiguration.getSecurityPolicy() != SecurityPolicy.NONE && !Arrays.equals((byte[])object3, TcpConnection.this.securityConfiguration.getEncodedLocalCertificateThumbprint())) {
                                            this.closeError = new ServiceResultException("Error, certificate thumbprint mismatch");
                                            logger.warn("{} Error, certificate thumbprint mismatch", (Object)TcpConnection.this.addr);
                                            break block46;
                                        }
                                        object = null;
                                        if (object4 != null && ((Object)object4).length > 0) {
                                            try {
                                                object = new Cert(CertificateUtils.decodeX509Certificate((byte[])object4));
                                            }
                                            catch (CertificateException certificateException) {
                                                this.closeError = new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Error, Invalid Remote Certificate");
                                                logger.warn(TcpConnection.this.addr + " Error, Invalid Remote Certificate", (Throwable)certificateException);
                                                break block46;
                                            }
                                        }
                                        if (TcpConnection.this.certificateValidator != null && (object5 = TcpConnection.this.certificateValidator.validateCertificate((Cert)object)) != null && !((StatusCode)object5).isGood()) {
                                            this.closeError = new ServiceResultException((StatusCode)object5, "Remote certificate not accepted");
                                            logger.info("{} Remote certificate not accepted: {}", (Object)TcpConnection.this.addr, object5);
                                            break block46;
                                        }
                                        TcpConnection.this.securityConfiguration = new SecurityConfiguration(TcpConnection.this.securityConfiguration.getSecurityMode(), TcpConnection.this.securityConfiguration.getLocalCertificate2(), (Cert)object);
                                        object5 = new ChunkAsymmDecryptVerifier((ByteBuffer)((Object)iterator), TcpConnection.this.securityConfiguration);
                                        ((ChunkAsymmDecryptVerifier)object5).run();
                                    }
                                    catch (ServiceResultException serviceResultException) {
                                        this.closeError = serviceResultException;
                                        logger.warn(TcpConnection.this.addr + "", (Throwable)serviceResultException);
                                        break block46;
                                    }
                                }
                                if (n4 == 4674381) {
                                    int n11 = ChunkUtils.getTokenId((ByteBuffer)((Object)iterator));
                                    object2 = null;
                                    logger.debug("tokens({})={}", (Object)TcpConnection.this.tokens.size(), TcpConnection.this.tokens);
                                    object4 = TcpConnection.this.tokens.iterator();
                                    while (object4.hasNext()) {
                                        object3 = (SecurityToken)object4.next();
                                        if (((SecurityToken)object3).getTokenId() != n11 || ((SecurityToken)object3).getSecureChannelId() != n10) continue;
                                        object2 = object3;
                                    }
                                    logger.debug("token={}", object2);
                                    if (object2 == null) {
                                        this.closeError = new ServiceResultException("Unexpected securityTokenId = " + n11);
                                        logger.warn("{} Unexpected securityTokenId = {}", (Object)TcpConnection.this.addr, (Object)n11);
                                        break block46;
                                    }
                                    if (!((SecurityToken)object2).isValid()) {
                                        this.closeError = new ServiceResultException("SecurityToken " + n11 + " has timeouted");
                                        logger.warn("{} SecurityToken {} has timeouted", (Object)TcpConnection.this.addr, object2);
                                        break block46;
                                    }
                                    TcpConnection.this.activeTokenIdMap.put(n10, (SecurityToken)object2);
                                    object4 = new ChunkSymmDecryptVerifier((ByteBuffer)((Object)iterator), (SecurityToken)object2);
                                    ((ChunkSymmDecryptVerifier)object4).run();
                                    ((ByteBuffer)((Object)iterator)).position(24);
                                }
                                ((ByteBuffer)((Object)iterator)).position(((Buffer)((Object)iterator)).position() - 8);
                                int n12 = ((ByteBuffer)((Object)iterator)).getInt();
                                object2 = TcpConnection.this.sequenceNumbers.get(n);
                                if (!(n4 != 4674381 && object2 == null || ((SequenceNumber)object2).testAndSetRecvSequencenumber(n12))) {
                                    this.closeError = new ServiceResultException("Sequence number mismatch");
                                    logger.warn("{} Sequence number mismatch: {} vs. {}", new Object[]{TcpConnection.this.addr, ((SequenceNumber)object2).getRecvSequenceNumber(), n12});
                                    break block46;
                                }
                                n3 = ((ByteBuffer)((Object)iterator)).getInt();
                                if (n5 == 0) {
                                    n2 = n3;
                                } else if (n3 != n2) {
                                    this.closeError = new ServiceResultException("Request id mismatch");
                                    logger.warn("{} Request id mismatch", (Object)TcpConnection.this.addr);
                                    break block46;
                                }
                                arrayList.add((ByteBuffer)((Object)iterator));
                                ++n5;
                            } while (n6 == 0x43000000);
                            if (n6 == 0x41000000) continue;
                            ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(arrayList.toArray(new ByteBuffer[arrayList.size()]));
                            byteBufferArrayReadable.order(ByteOrder.LITTLE_ENDIAN);
                            BinaryDecoder binaryDecoder = new BinaryDecoder(byteBufferArrayReadable);
                            binaryDecoder.setEncoderContext(this.ctx);
                            t = binaryDecoder.getMessage();
                            if (t instanceof OpenSecureChannelResponse) {
                                iterator = (OpenSecureChannelResponse)t;
                                ChannelSecurityToken channelSecurityToken = ((OpenSecureChannelResponse)((Object)iterator)).getSecurityToken();
                                byte[] byArray = TcpConnection.this.clientNonces.get(n2);
                                object2 = ((OpenSecureChannelResponse)((Object)iterator)).getServerNonce();
                                n3 = n;
                                int n13 = channelSecurityToken.getChannelId().intValue();
                                if (n13 != n3) {
                                    logger.warn("{} OpenSecureChannel, server sent two secureChannelIds {} and {} using {}", new Object[]{TcpConnection.this.addr, n3, n13, n3});
                                }
                                try {
                                    object = new SecurityToken(TcpConnection.this.securityConfiguration, n3, channelSecurityToken.getTokenId().intValue(), System.currentTimeMillis(), channelSecurityToken.getRevisedLifetime().longValue(), byArray, (byte[])object2);
                                    logger.debug("new token={}", object);
                                    TcpConnection.this.tokens.add((SecurityToken)object);
                                    if (TcpConnection.this.sequenceNumbers.containsKey(n3)) break block47;
                                    TcpConnection.this.sequenceNumbers.put(n3, new SequenceNumber());
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.closeError = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + " SecurityTokenError ", (Throwable)serviceResultException);
                                    break;
                                }
                            }
                        }
                        TcpConnection.this.clientNonces.remove(n2);
                        for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                            iMessageListener.onMessage(n2, n, (IEncodeable)t);
                        }
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketException) {
                        if (!this.closing) {
                            logger.info("{} Closed (unexpected)", (Object)TcpConnection.this.addr);
                            this.closeError = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (unexpected)");
                        } else {
                            logger.info("{} Closed (expected)", (Object)TcpConnection.this.addr);
                            this.closeError = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (expected)");
                        }
                    } else if (iOException instanceof EOFException) {
                        this.closeError = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (graceful)");
                        logger.info("{} Closed (graceful)", (Object)TcpConnection.this.addr);
                    } else {
                        this.closeError = StackUtils.toServiceResultException(iOException);
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)iOException);
                    }
                }
                catch (DecodingException decodingException) {
                    if (decodingException.getCause() != null && decodingException.getCause() instanceof EOFException) {
                        logger.info("{} Closed", (Object)TcpConnection.this.addr);
                    } else {
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)decodingException);
                    }
                    this.closeError = decodingException;
                }
                catch (RuntimeServiceResultException runtimeServiceResultException) {
                    ServiceResultException serviceResultException = runtimeServiceResultException.getCause();
                    logger.warn(TcpConnection.this.addr + " Error", (Throwable)serviceResultException);
                    this.closeError = serviceResultException;
                }
            }
            TcpConnection.this.close(this.closeError);
        }
    }

    private class MessageBuffers {
        private ByteBuffer[] chunks;
        private ByteBuffer[] plaintexts;

        public MessageBuffers(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
            this.chunks = byteBufferArray;
            this.plaintexts = byteBufferArray2;
        }

        public ByteBuffer[] getChunks() {
            return this.chunks;
        }

        public ByteBuffer[] getPlaintexts() {
            return this.plaintexts;
        }
    }
}

