/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    public static final SecurityConfiguration NO_SECURITY;
    static Logger log;
    SecurityMode mode;
    KeyPair localCertificate = null;
    Cert remoteCertificate = null;

    public SecurityConfiguration(SecurityMode securityMode, KeyPair keyPair, Cert cert) {
        if (securityMode == null) {
            throw new NullPointerException("SecurityMode mode is null");
        }
        this.mode = securityMode;
        if (securityMode.getMessageSecurityMode().hasSigning()) {
            if (keyPair == null) {
                throw new NullPointerException("localApplicationInstanceCertificate is null");
            }
            this.localCertificate = keyPair;
            if (cert == null) {
                throw new NullPointerException("remoteCertificate is null");
            }
            this.remoteCertificate = cert;
        }
    }

    public Certificate getReceiverCertificate() {
        if (this.remoteCertificate == null) {
            return null;
        }
        return this.remoteCertificate.getCertificate();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.mode.getSecurityPolicy();
    }

    public byte[] getEncodedLocalPrivateKey() {
        if (this.localCertificate == null) {
            return null;
        }
        return this.localCertificate.getPrivateKey().getPrivateKey().getEncoded();
    }

    public byte[] getEncodedLocalCertificate() {
        if (this.localCertificate == null) {
            return null;
        }
        return this.localCertificate.getCertificate().getEncoded();
    }

    public byte[] getEncodedRemoteCertificateThumbprint() {
        if (this.remoteCertificate == null) {
            return null;
        }
        return this.remoteCertificate.getEncodedThumbprint();
    }

    public byte[] getEncodedRemoteCertificate() {
        if (this.remoteCertificate == null) {
            return null;
        }
        return this.remoteCertificate.getEncoded();
    }

    public byte[] getEncodedLocalCertificateThumbprint() {
        if (this.localCertificate == null) {
            return null;
        }
        return this.localCertificate.getCertificate().getEncodedThumbprint();
    }

    public RSAPrivateKey getLocalPrivateKey() {
        if (this.localCertificate == null) {
            return null;
        }
        return this.localCertificate.getPrivateKey().getPrivateKey();
    }

    public Certificate getLocalCertificate() {
        if (this.localCertificate == null) {
            return null;
        }
        return this.localCertificate.getCertificate().getCertificate();
    }

    public Certificate getRemoteCertificate() {
        if (this.remoteCertificate == null) {
            return null;
        }
        return this.remoteCertificate.getCertificate();
    }

    public Cert getRemoteCertificate2() {
        return this.remoteCertificate;
    }

    public KeyPair getLocalCertificate2() {
        return this.localCertificate;
    }

    public SecurityMode getSecurityMode() {
        return this.mode;
    }

    public MessageSecurityMode getMessageSecurityMode() {
        return this.mode.getMessageSecurityMode();
    }

    static {
        log = LoggerFactory.getLogger(SecurityConfiguration.class);
        NO_SECURITY = new SecurityConfiguration(SecurityMode.NONE, null, null);
    }
}

