/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.util.EnumSet;

public enum SecurityAlgorithm {
    HmacSha1(AlgorithmType.SymmetricSignature, "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "HmacSHA1", 160),
    HmacSha256(AlgorithmType.SymmetricSignature, "http://www.w3.org/2000/09/xmldsig#hmac-sha256", "HmacSHA256", 256),
    Aes128(AlgorithmType.SymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES/CBC/NoPadding", 128),
    Aes256(AlgorithmType.SymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES/CBC/NoPadding", 256),
    RsaSha1(AlgorithmType.AsymmetricSignature, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA", 160),
    RsaSha256(AlgorithmType.AsymmetricSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "SHA256withRSA", 256),
    Rsa15(AlgorithmType.AsymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA/NONE/PKCS1Padding", 0),
    RsaOaep(AlgorithmType.AsymmetricEncryption, "http://www.w3.org/2001/04/xmlenc#rsa-oaep", "RSA/NONE/OAEPWithSHA1AndMGF1Padding", 0),
    KwRsaOaep(AlgorithmType.AsymmetricKeywrap, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "", 0),
    KwRsa15(AlgorithmType.AsymmetricKeywrap, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "", 0),
    PSha1(AlgorithmType.KeyDerivation, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "HmacSHA1", 0),
    PSha256(AlgorithmType.KeyDerivation, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha256", "HmacSHA256", 0);

    private AlgorithmType type;
    private final String uri;
    private final String standardName;
    private final String transformation;
    private final int keySize;
    private final String mode;
    private final String padding;

    public AlgorithmType getType() {
        return this.type;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getUri() {
        return this.uri;
    }

    public String getStandardName() {
        return this.standardName;
    }

    private SecurityAlgorithm(AlgorithmType algorithmType, String string2, String string3, int n2) {
        this.type = algorithmType;
        this.uri = string2;
        this.transformation = string3;
        String[] stringArray = string3.split("/");
        this.standardName = stringArray[0];
        this.mode = stringArray.length > 1 ? stringArray[1] : "EBC";
        this.padding = stringArray.length > 2 ? stringArray[2] : "PKCS5Padding";
        this.keySize = n2;
    }

    public String toString() {
        return "Algorithm URI=" + this.uri + " StandardName=" + this.standardName + " Transformation=" + this.transformation;
    }

    public static SecurityAlgorithm valueOfUri(String string) {
        for (SecurityAlgorithm securityAlgorithm : EnumSet.allOf(SecurityAlgorithm.class)) {
            if (!securityAlgorithm.getUri().equals(string)) continue;
            return securityAlgorithm;
        }
        return null;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public static enum AlgorithmType {
        SymmetricSignature,
        SymmetricEncryption,
        AsymmetricSignature,
        AsymmetricEncryption,
        AsymmetricKeywrap,
        KeyDerivation;

    }
}

