/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Scanner;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.utils.BouncyCastleUtils;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivKey {
    private static final String END_RSA_PRIVATE_KEY = "\n-----END RSA PRIVATE KEY-----";
    private static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final String END_PRIVATE_KEY_REGEX = "-----END .*PRIVATE KEY-----";
    private static final String BEGIN_PRIVATE_KEY_REGEX = "-----BEGIN .*PRIVATE KEY-----";
    public final RSAPrivateKey privateKey;
    private static Logger logger = LoggerFactory.getLogger(PrivKey.class);

    public static PrivKey loadFromKeyStore(URL uRL, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        RSAPrivateKey rSAPrivateKey = CertificateUtils.loadFromKeyStore(uRL, string);
        return new PrivKey(rSAPrivateKey);
    }

    public static PrivKey load(File file, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        if (file.length() < 3L) {
            throw new IllegalArgumentException("file is not a valid private key (too short file)");
        }
        byte[] byArray = FileUtil.readFile(file);
        return PrivKey.load(byArray, string);
    }

    public static PrivKey load(InputStream inputStream, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        byte[] byArray = FileUtil.readStream(inputStream);
        return PrivKey.load(byArray, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivKey load(byte[] byArray, String string) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        String string2 = "";
        byte[] byArray2 = null;
        if (byArray[0] == 45 && byArray[1] == 45 && byArray[2] == 45 || byArray[3] == 45 && byArray[4] == 45 && byArray[5] == 45) {
            boolean bl2;
            StringBuilder stringBuilder;
            object4 = new String(byArray);
            object3 = new Scanner((String)object4);
            try {
                stringBuilder = new StringBuilder();
                object2 = "";
                bl2 = false;
                while (((Scanner)object3).hasNextLine()) {
                    object = ((Scanner)object3).nextLine();
                    if (((String)object).matches(BEGIN_PRIVATE_KEY_REGEX)) {
                        bl2 = true;
                        continue;
                    }
                    if (((String)object).matches(END_PRIVATE_KEY_REGEX)) {
                        break;
                    }
                    if (((String)object).startsWith("Proc-Type: 4,ENCRYPTED")) {
                        bl = true;
                        continue;
                    }
                    if (((String)object).startsWith("DEK-Info:")) {
                        stringArray = ((String)object).substring(10).split(",");
                        string2 = stringArray[0];
                        object2 = stringArray[1];
                        byArray2 = CryptoUtil.hexToBytes((String)object2);
                        continue;
                    }
                    stringBuilder.append(((String)object).trim());
                }
            }
            finally {
                ((Scanner)object3).close();
            }
            if (bl2) {
                byArray = CryptoUtil.base64Decode(stringBuilder.toString());
            }
        }
        if (bl) {
            if (string == null || string.isEmpty()) {
                throw new SecurityException("Encrypted private key requires a password.");
            }
            object4 = new IvParameterSpec(byArray2);
            stringArray = string2.split("-");
            object3 = stringArray[0];
            int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 128;
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            object2 = BouncyCastleUtils.PKCS5PasswordToBytes(string.toCharArray());
            object = PrivKey.generateDerivedKey(n / 8, (byte[])object2, byArray3);
            SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, (String)object3);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKeySpec, (AlgorithmParameterSpec)object4);
            byArray = cipher.doFinal(byArray);
        }
        return new PrivKey(byArray);
    }

    private static byte[] generateDerivedKey(int n, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray3 = new byte[messageDigest.getDigestLength()];
        byte[] byArray4 = new byte[n];
        int n2 = 0;
        while (true) {
            messageDigest.update(byArray, 0, byArray.length);
            messageDigest.update(byArray2, 0, byArray2.length);
            byArray3 = messageDigest.digest();
            int n3 = n > byArray3.length ? byArray3.length : n;
            System.arraycopy(byArray3, 0, byArray4, n2, n3);
            n2 += n3;
            if ((n -= n3) == 0) break;
            messageDigest.reset();
            messageDigest.update(byArray3, 0, byArray3.length);
        }
        return byArray4;
    }

    @Deprecated
    public static PrivKey load(File file) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] byArray = FileUtil.readFile(file);
        return new PrivKey(byArray);
    }

    public static PrivKey loadFromKeyStore(File file, String string) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        return PrivKey.loadFromKeyStore(file.toURI().toURL(), string);
    }

    public void save(File file) throws IOException {
        FileUtil.writeFile(file, this.getEncodedPrivateKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, String string) throws IOException {
        if (string == null || string.length() == 0) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.getPrivateKey().getEncoded());
            FileWriter fileWriter = new FileWriter(file);
            try {
                fileWriter.append(BEGIN_RSA_PRIVATE_KEY);
                fileWriter.append(CryptoUtil.base64Encode(pKCS8EncodedKeySpec.getEncoded()));
                fileWriter.append(END_RSA_PRIVATE_KEY);
            }
            finally {
                fileWriter.close();
            }
        } else {
            this.savePemWithBC(file, string);
        }
    }

    private void savePemWithBC(File file, String string) throws IOException {
        BouncyCastleUtils.writeToPem(this.getPrivateKey(), file, string, "AES-128-CBC");
    }

    public PrivKey(byte[] byArray) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (byArray == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.privateKey = this.decodeRSAPrivateKey(byArray);
    }

    private RSAPrivateKey decodeRSAPrivateKey(byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", CryptoUtil.getSecurityProviderName());
                return (RSAPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                logger.error("Could not read private key with default Provider and Bouncy Castle not available");
                throw new RuntimeException("Could not read private key with default Provider and Bouncy Castle not available", noSuchProviderException);
            }
        }
    }

    public PrivKey(RSAPrivateKey rSAPrivateKey) {
        this.privateKey = rSAPrivateKey;
    }

    public byte[] getEncodedPrivateKey() {
        return this.privateKey.getEncoded();
    }

    public RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void saveToKeyStore(Cert cert, File file, String string, String string2, String string3) throws IOException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException {
        String string4 = "key";
        CertificateUtils.saveToProtectedStore(this.getPrivateKey(), cert.getCertificate(), file, string4, string, string2, string3);
    }
}

