/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.impl;

import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.ResultListener;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResultImpl<T>
implements AsyncResult<T> {
    static Logger logger = LoggerFactory.getLogger(AsyncResultImpl.class);
    static Logger listenerLogger = LoggerFactory.getLogger(ResultListener.class);
    static Executor executor = StackUtils.BLOCKING_EXECUTOR;
    ServiceResultException error;
    T result;
    ResultListener<T> listener;
    Semaphore s = new Semaphore(0);

    @Override
    public ServiceResultException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(final ServiceResultException serviceResultException) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.error = serviceResultException;
            final ResultListener<T> resultListener = this.listener;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            resultListener.onError(serviceResultException);
                        }
                        catch (RuntimeException runtimeException) {
                            listenerLogger.error("Unexpected RuntimeException in ResultListener#onError(", (Throwable)runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.s.release(Integer.MAX_VALUE);
    }

    private boolean isFinished() {
        return this.result != null || this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(T t) {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            final ResultListener<T> resultListener = this.listener;
            if (resultListener != null) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            resultListener.onCompleted(AsyncResultImpl.this.result);
                        }
                        catch (RuntimeException runtimeException) {
                            listenerLogger.error("Unexpected RuntimeException in ResultListener#onCompleted", (Throwable)runtimeException);
                        }
                        finally {
                            AsyncResultImpl.this.finish();
                        }
                    }
                });
            }
        }
        this.s.release(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorSync(ServiceResultException serviceResultException) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.error = serviceResultException;
            ResultListener<T> resultListener = this.listener;
            if (resultListener != null) {
                try {
                    resultListener.onError(serviceResultException);
                }
                catch (RuntimeException runtimeException) {
                    listenerLogger.error("Unexpected RuntimeException in ResultListener#onError(", (Throwable)runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.s.release(Integer.MAX_VALUE);
    }

    private void finish() {
        this.setListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultSync(T t) throws RuntimeException {
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            if (this.isFinished()) {
                return;
            }
            this.result = t;
            ResultListener<T> resultListener = this.listener;
            if (resultListener != null) {
                try {
                    resultListener.onCompleted(t);
                }
                catch (RuntimeException runtimeException) {
                    listenerLogger.error("Unexpected RuntimeException in ResultListener#onCompleted(", (Throwable)runtimeException);
                }
                finally {
                    this.finish();
                }
            }
        }
        this.s.release(Integer.MAX_VALUE);
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public AsyncResult.AsyncResultStatus getStatus() {
        if (this.error != null) {
            return AsyncResult.AsyncResultStatus.Failed;
        }
        if (this.result != null) {
            return AsyncResult.AsyncResultStatus.Succeed;
        }
        return AsyncResult.AsyncResultStatus.Waiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(ResultListener<T> resultListener) {
        T t;
        ServiceResultException serviceResultException;
        AsyncResultImpl asyncResultImpl = this;
        synchronized (asyncResultImpl) {
            this.listener = resultListener;
            serviceResultException = this.error;
            t = this.result;
        }
        if (resultListener != null) {
            if (t != null) {
                resultListener.onCompleted(t);
            }
            if (serviceResultException != null) {
                resultListener.onError(serviceResultException);
            }
        }
    }

    @Override
    public T waitForResult() throws ServiceResultException {
        try {
            this.s.acquire();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("timeout: ", (Throwable)this.error);
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.error != null) {
            logger.debug("error: ", (Throwable)this.error);
            if (this.error instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.error).getServiceFault());
            }
            throw this.error;
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
    }

    @Override
    public T waitForResult(long l, TimeUnit timeUnit) throws ServiceResultException {
        try {
            this.s.tryAcquire(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            throw new ServiceResultException(StatusCodes.Bad_Timeout, (Throwable)interruptedException);
        }
        if (this.result != null) {
            return this.result;
        }
        logger.debug("error:", (Throwable)this.error);
        if (this.error != null) {
            if (this.error instanceof ServiceFaultException) {
                throw new ServiceFaultException(((ServiceFaultException)this.error).getServiceFault());
            }
            throw this.error;
        }
        throw new ServiceResultException(StatusCodes.Bad_Timeout);
    }

    public void setSource(AsyncResult<T> asyncResult) {
        asyncResult.setListener(new ResultListener<T>(){

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResultImpl.this.setError(serviceResultException);
            }

            @Override
            public void onCompleted(T t) {
                AsyncResultImpl.this.setResult(t);
            }
        });
    }
}

