/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.application.Server;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.endpoint.AbstractServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.https.HttpsServerConnection;
import org.opcfoundation.ua.transport.https.HttpsServerEndpointHandler;
import org.opcfoundation.ua.transport.https.HttpsServerPendingRequest;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.nio.PendingRequest;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServerSecureChannel
extends AbstractServerSecureChannel {
    private static Logger logger = LoggerFactory.getLogger(HttpsServerSecureChannel.class);
    private EndpointBinding endpointBinding;
    private HttpsServerEndpointHandler httpsEndpointHandler;
    private volatile HttpsServerConnection lastConnection;
    Map<Integer, PendingRequest> requests = new ConcurrentHashMap<Integer, PendingRequest>();

    @Override
    public KeyPair getLocalCertificate() {
        return null;
    }

    @Override
    public Cert getRemoteCertificate() {
        return null;
    }

    public HttpsServerSecureChannel(HttpsServerEndpointHandler httpsServerEndpointHandler, int n) {
        super(n);
        this.endpointBinding = httpsServerEndpointHandler.endpointBinding;
        this.httpsEndpointHandler = httpsServerEndpointHandler;
    }

    @Override
    public MessageSecurityMode getMessageSecurityMode() {
        return MessageSecurityMode.None;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        return SecurityPolicy.NONE;
    }

    @Override
    public synchronized void setError(ServiceResultException serviceResultException) {
        super.setError(serviceResultException);
    }

    @Override
    protected void onListenerException(RuntimeException runtimeException) {
        this.setError(StackUtils.toServiceResultException(runtimeException));
    }

    @Override
    public ServerConnection getConnection() {
        return this.lastConnection;
    }

    public void setConnection(HttpsServerConnection httpsServerConnection) {
        this.lastConnection = httpsServerConnection;
    }

    @Override
    public String getConnectURL() {
        return this.endpointBinding.endpointAddress.getEndpointUrl();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void getPendingServiceRequests(Collection<EndpointServiceRequest<?, ?>> collection) {
        HashMap<Integer, HttpsServerPendingRequest> hashMap = new HashMap<Integer, HttpsServerPendingRequest>(this.httpsEndpointHandler.pendingRequests);
        for (HttpsServerPendingRequest httpsServerPendingRequest : hashMap.values()) {
            if (httpsServerPendingRequest.secureChannelId != this.getSecureChannelId()) continue;
            collection.add(httpsServerPendingRequest);
        }
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpointBinding.endpointAddress;
    }

    @Override
    public Server getServer() {
        return this.endpointBinding.serviceServer;
    }

    @Override
    public boolean needsCertificate() {
        return true;
    }
}

