/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.util.EntityUtils;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.transport.AsyncWrite;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.transport.https.HttpsServerConnection;
import org.opcfoundation.ua.transport.https.HttpsServerEndpointHandler;
import org.opcfoundation.ua.transport.https.HttpsServerSecureChannel;
import org.opcfoundation.ua.transport.tcp.impl.ErrorMessage;
import org.opcfoundation.ua.utils.StackUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpsServerPendingRequest
extends EndpointServiceRequest<ServiceRequest, ServiceResponse>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HttpsServerPendingRequest.class);
    HttpsServerEndpointHandler endpoint;
    HttpAsyncExchange httpExchange;
    HttpRequest httpRequest;
    HttpEntity requestEntity;
    HttpsServerSecureChannel channel;
    String securityPolicyUri;
    int requestId;
    AsyncWrite write;
    Thread workerThread;
    int secureChannelId = -1;

    public HttpsServerPendingRequest(HttpsServerEndpointHandler httpsServerEndpointHandler, HttpAsyncExchange httpAsyncExchange, HttpRequest httpRequest, HttpsServerSecureChannel httpsServerSecureChannel, int n) {
        super(null, httpsServerEndpointHandler.endpointBinding.serviceServer, httpsServerEndpointHandler.endpointBinding.endpointAddress);
        this.endpoint = httpsServerEndpointHandler;
        this.httpRequest = httpRequest;
        this.requestId = n;
        this.httpExchange = httpAsyncExchange;
        this.channel = httpsServerSecureChannel;
        if (httpRequest instanceof HttpMessage) {
            HttpRequest httpRequest2 = httpRequest;
            Header header = httpRequest2.getFirstHeader("OPCUA-SecurityPolicy");
            if (header != null) {
                this.securityPolicyUri = header.getValue();
            }
            if (this.securityPolicyUri == null) {
                this.securityPolicyUri = "http://opcfoundation.org/UA/SecurityPolicy#TLS-1-0";
            }
        }
    }

    @Override
    public ServerSecureChannel getChannel() {
        return this.channel;
    }

    @Override
    public void sendResponse(final AsyncWrite asyncWrite) {
        this.write = asyncWrite;
        final int n = asyncWrite.getMessage() instanceof ServiceResponse ? 200 : 400;
        asyncWrite.setQueued();
        if (Thread.currentThread() == this.workerThread) {
            asyncWrite.setWriting();
            this.sendResponse(n, asyncWrite.getMessage());
            asyncWrite.setWritten();
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    asyncWrite.setWriting();
                    HttpsServerPendingRequest.this.sendResponse(n, asyncWrite.getMessage());
                    asyncWrite.setWritten();
                }
            };
            StackUtils.getBlockingWorkExecutor().execute(runnable);
        }
    }

    @Override
    public AsyncWrite sendResponse(ServiceResponse serviceResponse) {
        this.write = new AsyncWrite(serviceResponse);
        this.sendResponse(this.write);
        return this.write;
    }

    @Override
    public void run() {
        Object object;
        this.workerThread = Thread.currentThread();
        Header header = this.httpRequest.getFirstHeader("Content-Length");
        if (header != null && !((String)(object = header.getValue().trim())).isEmpty()) {
            try {
                long l = Long.valueOf((String)object);
                long l2 = this.endpoint.endpointConfiguration.getMaxMessageSize().intValue();
                if (l2 != 0L && l > l2) {
                    this.sendError(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            Object object2;
            if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
                object2 = (HttpEntityEnclosingRequest)this.httpRequest;
                this.requestEntity = object2.getEntity();
                long l = this.requestEntity.getContentLength();
                long l3 = this.endpoint.endpointConfiguration.getMaxMessageSize().intValue();
                if (l3 != 0L && l > l3) {
                    this.sendError(500, StatusCodes.Bad_RequestTooLarge, "No request message");
                    return;
                }
            } else {
                this.sendError(500, StatusCodes.Bad_RequestTypeInvalid, "No request message");
                return;
            }
            object = EntityUtils.toByteArray((HttpEntity)this.requestEntity);
            object2 = new BinaryDecoder((byte[])object);
            ((BinaryDecoder)object2).setEncoderContext(this.endpoint.getEncoderContext());
            this.request = (ServiceRequest)((BinaryDecoder)object2).getMessage();
            logger.trace("request={}", this.request);
            logger.debug("request={}", (Object)this.request.getClass().getSimpleName());
        }
        catch (IllegalStateException illegalStateException) {
            this.sendError(500, StatusCodes.Bad_UnexpectedError, illegalStateException.getMessage());
            return;
        }
        catch (IOException iOException) {
            this.sendError(400, StatusCodes.Bad_UnexpectedError, iOException.getMessage());
            return;
        }
        catch (DecodingException decodingException) {
            this.sendError(400, StatusCodes.Bad_RequestTypeInvalid, decodingException.getMessage());
            return;
        }
        this.endpoint.handleMessage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendResponse(int n, IEncodeable iEncodeable) {
        try {
            HttpResponse httpResponse;
            block7: {
                httpResponse = this.httpExchange.getResponse();
                httpResponse.setHeader("Content-Type", "application/octet-stream");
                httpResponse.setStatusCode(n);
                if (iEncodeable != null) {
                    try {
                        EncoderCalc encoderCalc;
                        logger.trace("sendResponse: requestId={} statusCode={} responseObject={}", new Object[]{this.requestId, n, iEncodeable});
                        logger.debug("sendResponse: requestId={} statusCode={} responseObject={}", new Object[]{this.requestId, n, iEncodeable.getClass().getSimpleName()});
                        if (logger.isDebugEnabled() && this.channel.getConnection() != null) {
                            encoderCalc = ((HttpsServerConnection)this.channel.getConnection()).getNHttpServerConnection();
                            logger.debug("sendResponse: timeout={} {} context={}", new Object[]{this.httpExchange.getTimeout(), encoderCalc.getSocketTimeout(), encoderCalc.getContext()});
                        }
                        encoderCalc = new EncoderCalc();
                        encoderCalc.setEncoderContext(this.endpoint.getEncoderContext());
                        encoderCalc.putMessage(iEncodeable);
                        int n2 = encoderCalc.getLength();
                        byte[] byArray = new byte[n2];
                        BinaryEncoder binaryEncoder = new BinaryEncoder(byArray);
                        binaryEncoder.setEncoderContext(this.endpoint.getEncoderContext());
                        binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
                        binaryEncoder.putMessage(iEncodeable);
                        httpResponse.setEntity((HttpEntity)new NByteArrayEntity(byArray));
                    }
                    catch (EncodingException encodingException) {
                        logger.info("sendResponse: Encoding failed", (Throwable)encodingException);
                        if (iEncodeable instanceof ErrorMessage) break block7;
                        httpResponse.setStatusCode(500);
                    }
                }
            }
            logger.debug("sendResponse: {} length={}", (Object)httpResponse, (Object)httpResponse.getEntity().getContentLength());
            this.httpExchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(httpResponse));
        }
        finally {
            this.endpoint.pendingRequests.remove(this.requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendError(int n, UnsignedInteger unsignedInteger, String string) {
        try {
            ErrorMessage errorMessage = null;
            if (string != null) {
                errorMessage = new ErrorMessage(unsignedInteger, string);
            }
            this.sendResponse(n, errorMessage);
        }
        finally {
            this.endpoint.pendingRequests.remove(this.requestId);
        }
    }
}

