/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.CloseSecureChannelRequest;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.OpenSecureChannelRequest;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.https.HttpsServer;
import org.opcfoundation.ua.transport.https.HttpsServerConnection;
import org.opcfoundation.ua.transport.https.HttpsServerPendingRequest;
import org.opcfoundation.ua.transport.https.HttpsServerSecureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServerEndpointHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpsServerEndpointHandler.class);
    EndpointBinding endpointBinding;
    HttpsServer endpointServer;
    EndpointConfiguration endpointConfiguration;
    AtomicInteger requestIdCounter = new AtomicInteger();
    Map<Integer, HttpsServerPendingRequest> pendingRequests = new ConcurrentHashMap<Integer, HttpsServerPendingRequest>();
    HttpsServerSecureChannel singleSecureChannel;

    public HttpsServerEndpointHandler(EndpointBinding endpointBinding) {
        this.endpointBinding = endpointBinding;
        this.endpointServer = (HttpsServer)endpointBinding.endpointServer;
        this.endpointConfiguration = endpointBinding.endpointAddress.getEndpointConfiguration();
        this.singleSecureChannel = new HttpsServerSecureChannel(this, 1);
    }

    public EncoderContext getEncoderContext() {
        return this.endpointServer.getEncoderContext();
    }

    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        return new BasicAsyncRequestConsumer();
    }

    public void handle(HttpRequest httpRequest, HttpAsyncExchange httpAsyncExchange, HttpContext httpContext) throws HttpException, IOException {
        String string = httpRequest.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!string.equals("POST")) {
            throw new MethodNotSupportedException(string + " method not supported");
        }
        HttpsServerPendingRequest httpsServerPendingRequest = new HttpsServerPendingRequest(this, httpAsyncExchange, httpRequest, this.singleSecureChannel, this.requestIdCounter.getAndIncrement());
        this.pendingRequests.put(httpsServerPendingRequest.requestId, httpsServerPendingRequest);
        NHttpServerConnection nHttpServerConnection = (NHttpServerConnection)httpContext.getAttribute("http.connection");
        logger.debug("handle: {} context={}: {}", new Object[]{nHttpServerConnection, nHttpServerConnection.getContext(), httpRequest});
        HttpsServerConnection httpsServerConnection = (HttpsServerConnection)this.singleSecureChannel.getConnection();
        if (httpsServerConnection == null || !nHttpServerConnection.equals(httpsServerConnection.getNHttpServerConnection())) {
            HttpsServerConnection httpsServerConnection2 = new HttpsServerConnection(this.endpointServer, nHttpServerConnection);
            this.singleSecureChannel.setConnection(httpsServerConnection2);
            logger.info("HttpsServerEndpointHandler.handle(): singleSecureChannel.setConnection({})", (Object)nHttpServerConnection);
        }
        httpsServerPendingRequest.run();
    }

    void handleMessage(HttpsServerPendingRequest httpsServerPendingRequest) {
        Object Request = httpsServerPendingRequest.getRequest();
        if (Request instanceof OpenSecureChannelRequest) {
            try {
                this.handleOpenSecureChannelRequest((OpenSecureChannelRequest)Request, httpsServerPendingRequest);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                httpsServerPendingRequest.sendError(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else if (Request instanceof CloseSecureChannelRequest) {
            try {
                this.handleCloseSecureChannelRequest((CloseSecureChannelRequest)Request, httpsServerPendingRequest);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                httpsServerPendingRequest.sendError(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else if (Request instanceof ServiceRequest) {
            try {
                this.handleServiceRequest((ServiceRequest)Request, httpsServerPendingRequest);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Channel: ", (Throwable)serviceResultException);
                httpsServerPendingRequest.sendError(400, serviceResultException.getStatusCode().getValue(), serviceResultException.getMessage());
            }
        } else {
            String string = httpsServerPendingRequest.getClass().getSimpleName() + " is not a ServiceRequest.";
            logger.info("Channel: {} {}", (Object)httpsServerPendingRequest.getChannel().getSecureChannelId(), (Object)string);
            httpsServerPendingRequest.sendError(400, StatusCodes.Bad_RequestTypeInvalid, string);
            return;
        }
    }

    void handleServiceRequest(ServiceRequest serviceRequest, HttpsServerPendingRequest httpsServerPendingRequest) throws ServiceResultException {
        try {
            this.endpointBinding.serviceServer.getServiceHandlerComposition().serve(httpsServerPendingRequest);
        }
        catch (ServiceResultException serviceResultException) {
            String string = httpsServerPendingRequest.getClass().getSimpleName() + " is not a ServiceRequest.";
            logger.info("Channel: {} {}", (Object)httpsServerPendingRequest.getChannel().getSecureChannelId(), (Object)string);
            httpsServerPendingRequest.sendError(200, serviceResultException.getStatusCode().getValue(), string);
            return;
        }
    }

    void handleOpenSecureChannelRequest(OpenSecureChannelRequest openSecureChannelRequest, HttpsServerPendingRequest httpsServerPendingRequest) throws ServiceResultException {
        httpsServerPendingRequest.sendFault(ServiceFault.createServiceFault(StatusCodes.Bad_ServiceUnsupported));
    }

    void handleCloseSecureChannelRequest(CloseSecureChannelRequest closeSecureChannelRequest, HttpsServerPendingRequest httpsServerPendingRequest) throws ServiceResultException {
        httpsServerPendingRequest.sendFault(ServiceFault.createServiceFault(StatusCodes.Bad_ServiceUnsupported));
    }
}

