/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.nio.NHttpServerConnection;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.IConnectionListener;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.transport.https.HttpsServer;
import org.opcfoundation.ua.utils.AbstractState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsServerConnection
extends AbstractState<CloseableObjectState, ServiceResultException>
implements ServerConnection {
    private static Logger logger = LoggerFactory.getLogger(HttpsServerConnection.class);
    HttpsServer server;
    NHttpServerConnection conn;
    Socket socket;
    Map<Integer, ServerSecureChannel> secureChannels = new ConcurrentHashMap<Integer, ServerSecureChannel>();
    CopyOnWriteArrayList<ServerConnection.SecureChannelListener> secureChannelListeners = new CopyOnWriteArrayList();
    CopyOnWriteArrayList<IConnectionListener> connectionListeners = new CopyOnWriteArrayList();

    public HttpsServerConnection(HttpsServer httpsServer, NHttpServerConnection nHttpServerConnection) {
        super(CloseableObjectState.Closed);
        this.server = httpsServer;
        this.conn = nHttpServerConnection;
        this.socket = ((NHttpConnectionBase)nHttpServerConnection).getSocket();
        this.conn.setSocketTimeout(60000);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public NHttpServerConnection getNHttpServerConnection() {
        return this.conn;
    }

    @Override
    public void getSecureChannels(Collection<ServerSecureChannel> collection) {
        collection.addAll(this.secureChannels.values());
    }

    @Override
    public void addSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.secureChannelListeners.add(secureChannelListener);
    }

    @Override
    public void removeSecureChannelListener(ServerConnection.SecureChannelListener secureChannelListener) {
        this.secureChannelListeners.remove(secureChannelListener);
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.add(iConnectionListener);
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.connectionListeners.remove(iConnectionListener);
    }

    @Override
    protected void onStateTransition(CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        logger.debug("onStateTransition: {}->{}", (Object)closeableObjectState, (Object)closeableObjectState2);
        super.onStateTransition(closeableObjectState, closeableObjectState2);
        if (closeableObjectState2 == CloseableObjectState.Open) {
            for (IConnectionListener object : this.connectionListeners) {
                object.onOpen();
            }
        }
        if (closeableObjectState2 == CloseableObjectState.Closed) {
            ServiceResultException serviceResultException = new ServiceResultException(StatusCodes.Bad_CommunicationError);
            for (IConnectionListener iConnectionListener : this.connectionListeners) {
                iConnectionListener.onClosed(serviceResultException);
            }
        }
    }
}

