/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderMode;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.binary.BinaryDecoder;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.encoding.binary.EncoderCalc;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.https.HttpsClient;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.tcp.impl.ErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpsClientPendingRequest
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(HttpsClientPendingRequest.class);
    HttpsClient httpsClient;
    long startTime = System.currentTimeMillis();
    long timeoutTime = 0L;
    int requestId;
    AsyncResultImpl<ServiceResponse> result;
    ServiceRequest requestMessage;
    HttpPost httpPost;
    UnsignedInteger abortCode = null;
    int secureChannelId;
    String securityPolicy;

    public HttpsClientPendingRequest(HttpsClient httpsClient, ServiceRequest serviceRequest) {
        long l;
        this.httpsClient = httpsClient;
        this.requestMessage = serviceRequest;
        this.result = new AsyncResultImpl();
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l2 = l = unsignedInteger != null ? unsignedInteger.longValue() : (long)httpsClient.getOperationTimeout();
        if (l != 0L) {
            this.timeoutTime = this.startTime + l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            HttpResponse httpResponse;
            if (this.abortCode != null) {
                this.result.setError(new ServiceResultException(this.abortCode));
                return;
            }
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(this.httpsClient.connectUrl);
            String string = inetSocketAddress.getHostName();
            int n = inetSocketAddress.getPort();
            String string2 = UriUtil.getTransportProtocol(this.httpsClient.connectUrl);
            HttpHost httpHost = new HttpHost(string, n, string2);
            String string3 = this.httpsClient.transportChannelSettings.getDescription().getEndpointUrl();
            String string4 = string3 == null ? "" : string3;
            this.httpPost = new HttpPost(string4);
            this.httpPost.addHeader("OPCUA-SecurityPolicy", this.httpsClient.securityPolicyUri);
            this.httpPost.addHeader("Content-Type", "application/octet-stream");
            EncoderCalc encoderCalc = new EncoderCalc();
            encoderCalc.setEncoderContext(this.httpsClient.encoderCtx);
            encoderCalc.putMessage(this.requestMessage);
            int n2 = encoderCalc.getLength();
            int n3 = this.httpsClient.encoderCtx.getMaxMessageSize();
            if (n3 != 0 && n2 > n3) {
                EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxStringLength " + n3 + " < " + n2);
                logger.warn("run: failed", (Throwable)encodingException);
                throw encodingException;
            }
            byte[] byArray = new byte[n2];
            BinaryEncoder binaryEncoder = new BinaryEncoder(byArray);
            binaryEncoder.setEncoderContext(this.httpsClient.encoderCtx);
            binaryEncoder.setEncoderMode(EncoderMode.NonStrict);
            binaryEncoder.putMessage(this.requestMessage);
            this.httpPost.setEntity((HttpEntity)new NByteArrayEntity(byArray));
            if (this.abortCode != null) {
                this.result.setError(new ServiceResultException(this.abortCode));
                return;
            }
            try {
                httpResponse = this.httpsClient.httpclient.execute(httpHost, (HttpRequest)this.httpPost);
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                this.result.setError(new ServiceResultException(StatusCodes.Bad_SecurityPolicyRejected, (Throwable)sSLPeerUnverifiedException, "Could not negotiate a TLS security cipher or the server did not provide a valid certificate."));
                this.httpsClient.requests.remove(this.requestId);
                return;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            int n4 = httpResponse.getStatusLine().getStatusCode();
            if (n4 != 200) {
                UnsignedInteger unsignedInteger = StatusCodes.Bad_UnknownResponse;
                if (n4 == 501) {
                    unsignedInteger = StatusCodes.Bad_ServiceUnsupported;
                }
                String string5 = EntityUtils.toString((HttpEntity)httpEntity);
                this.result.setError(new ServiceResultException(unsignedInteger, n4 + ": " + string5));
                return;
            }
            if (this.abortCode != null) {
                this.result.setError(new ServiceResultException(this.abortCode));
                return;
            }
            byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            BinaryDecoder binaryDecoder = new BinaryDecoder(byArray);
            binaryDecoder.setEncoderContext(this.httpsClient.encoderCtx);
            Object t = binaryDecoder.getMessage();
            if (t instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)t;
                ServiceResultException serviceResultException = new ServiceResultException(new StatusCode(errorMessage.getError()), errorMessage.getReason());
                this.result.setError(serviceResultException);
                return;
            }
            try {
                this.result.setResult((ServiceResponse)t);
            }
            catch (ClassCastException classCastException) {
                this.result.setError(new ServiceResultException(classCastException));
                logger.error("Cannot cast response to ServiceResponse, response=" + t.getClass(), (Throwable)classCastException);
            }
        }
        catch (EncodingException encodingException) {
            this.result.setError(new ServiceResultException(StatusCodes.Bad_EncodingError, (Throwable)encodingException));
        }
        catch (ClientProtocolException clientProtocolException) {
            this.result.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)clientProtocolException));
        }
        catch (IOException iOException) {
            if (this.abortCode != null) {
                this.result.setError(new ServiceResultException(this.abortCode, (Throwable)iOException));
            } else {
                this.result.setError(new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException));
            }
        }
        catch (DecodingException decodingException) {
            this.result.setError(new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)decodingException));
        }
        catch (ServiceResultException serviceResultException) {
            this.result.setError(serviceResultException);
        }
        catch (RuntimeException runtimeException) {
            this.result.setError(new ServiceResultException(runtimeException));
        }
        finally {
            this.httpsClient.requests.remove(this.requestId);
        }
    }

    public void cancel() {
        if (this.httpsClient.requests.remove(this) == null) {
            return;
        }
        this.abortCode = StatusCodes.Bad_RequestCancelledByRequest;
        HttpPost httpPost = this.httpPost;
        if (httpPost != null) {
            httpPost.abort();
        }
    }

    public void timeout() {
        if (this.httpsClient.requests.remove(this.requestId) == null) {
            return;
        }
        this.abortCode = StatusCodes.Bad_Timeout;
        HttpPost httpPost = this.httpPost;
        if (httpPost != null) {
            httpPost.abort();
        }
        this.result.setError(new ServiceResultException(this.abortCode));
    }
}

