/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport.https;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.https.HttpsClientPendingRequest;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.tcp.io.ITransportChannel;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.StackUtils;
import org.opcfoundation.ua.utils.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsClient
implements ITransportChannel {
    static final ServiceResultException BAD_TIMEOUT = new ServiceResultException(StatusCodes.Bad_Timeout);
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final Logger logger = LoggerFactory.getLogger(HttpsClient.class);
    AtomicInteger requestIdCounter = new AtomicInteger(0);
    TransportChannelSettings transportChannelSettings;
    String connectUrl;
    HttpsSecurityPolicy securityPolicy;
    Executor executor = StackUtils.getBlockingWorkExecutor();
    SchemeRegistry sr;
    ClientConnectionManager ccm;
    int maxConnections = 20;
    DefaultHttpClient httpclient;
    String protocol;
    IEncodeableSerializer serializer;
    String securityPolicyUri;
    Map<Integer, HttpsClientPendingRequest> requests = new ConcurrentHashMap<Integer, HttpsClientPendingRequest>();
    Timer timer;
    AtomicReference<TimerTask> timeoutPendingRequestsTask = new AtomicReference<Object>(null);
    EncoderContext encoderCtx;
    AtomicInteger secureChannelIdCounter = new AtomicInteger();
    String[] cipherSuites;
    Runnable timeoutRun = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpsClient.this.cancelTimeoutPendingRequestTask();
            Map<Integer, HttpsClientPendingRequest> map = HttpsClient.this.requests;
            synchronized (map) {
                long l = System.currentTimeMillis();
                for (HttpsClientPendingRequest httpsClientPendingRequest : HttpsClient.this.requests.values()) {
                    if (httpsClientPendingRequest.timeoutTime == 0L || l < httpsClientPendingRequest.timeoutTime) continue;
                    long l2 = System.currentTimeMillis() - httpsClientPendingRequest.startTime;
                    long l3 = httpsClientPendingRequest.timeoutTime - httpsClientPendingRequest.startTime;
                    logger.warn("Request id={} msg={} timeouted {} ms elapsed. timeout at {} ms", new Object[]{httpsClientPendingRequest.requestId, httpsClientPendingRequest.requestMessage.getClass(), l2, l3});
                    httpsClientPendingRequest.timeout();
                }
            }
            HttpsClient.this.scheduleTimeoutRequestsTimer();
        }
    };
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new X509HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }

        public void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
        }

        public void verify(String string, X509Certificate x509Certificate) throws SSLException {
        }

        public void verify(String string, SSLSocket sSLSocket) throws IOException {
        }
    };

    public HttpsClient(String string) {
        if (!string.equals("http") && !string.equals("https")) {
            throw new IllegalArgumentException();
        }
        this.protocol = string;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.ccm = clientConnectionManager;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    @Override
    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.connectUrl = string;
        this.securityPolicyUri = transportChannelSettings.getDescription().getSecurityPolicyUri();
        this.transportChannelSettings = transportChannelSettings;
        HttpsSettings httpsSettings = transportChannelSettings.getHttpsSettings();
        HttpsSecurityPolicy[] httpsSecurityPolicyArray = httpsSettings.getHttpsSecurityPolicies();
        this.securityPolicy = httpsSecurityPolicyArray != null && httpsSecurityPolicyArray.length > 0 ? httpsSecurityPolicyArray[httpsSecurityPolicyArray.length - 1] : HttpsSecurityPolicy.TLS_1_1;
        if (this.securityPolicy != HttpsSecurityPolicy.TLS_1_0 && this.securityPolicy != HttpsSecurityPolicy.TLS_1_1 && this.securityPolicy != HttpsSecurityPolicy.TLS_1_2) {
            throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Https Client doesn't support securityPolicy " + this.securityPolicy);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initialize: url={}; settings={}", (Object)transportChannelSettings.getDescription().getEndpointUrl(), (Object)ObjectUtils.printFields(transportChannelSettings));
        }
        EndpointConfiguration endpointConfiguration = transportChannelSettings.getConfiguration();
        this.encoderCtx = encoderContext;
        this.encoderCtx.setMaxArrayLength(endpointConfiguration.getMaxArrayLength() != null ? endpointConfiguration.getMaxArrayLength() : 0);
        this.encoderCtx.setMaxStringLength(endpointConfiguration.getMaxStringLength() != null ? endpointConfiguration.getMaxStringLength() : 0);
        this.encoderCtx.setMaxByteStringLength(endpointConfiguration.getMaxByteStringLength() != null ? endpointConfiguration.getMaxByteStringLength() : 0);
        this.encoderCtx.setMaxMessageSize(endpointConfiguration.getMaxMessageSize() != null ? endpointConfiguration.getMaxMessageSize() : 0);
        this.timer = TimerUtil.getTimer();
        try {
            X509HostnameVerifier x509HostnameVerifier;
            SSLContext sSLContext;
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            if (this.protocol.equals("https")) {
                sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(httpsSettings.getKeyManagers(), httpsSettings.getTrustManagers(), null);
                x509HostnameVerifier = httpsSettings.getHostnameVerifier() != null ? httpsSettings.getHostnameVerifier() : SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(sSLContext, x509HostnameVerifier){

                    protected void prepareSocket(SSLSocket sSLSocket) throws IOException {
                        sSLSocket.setEnabledCipherSuites(HttpsClient.this.cipherSuites);
                    }
                };
                SSLEngine sSLEngine = sSLContext.createSSLEngine();
                Object[] objectArray = sSLEngine.getEnabledCipherSuites();
                this.cipherSuites = CryptoUtil.filterCipherSuiteList((String[])objectArray, this.securityPolicy.getCipherSuites());
                logger.info("Enabled protocols in SSL Engine are {}", (Object)Arrays.toString(sSLEngine.getEnabledProtocols()));
                logger.info("Enabled CipherSuites in SSL Engine are {}", (Object)Arrays.toString(objectArray));
                logger.info("Client CipherSuite selection for {} is {}", (Object)this.securityPolicy.getPolicyUri(), (Object)Arrays.toString(this.cipherSuites));
                Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactory);
                schemeRegistry.register(scheme);
            }
            if (this.protocol.equals("http")) {
                sSLContext = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
                schemeRegistry.register((Scheme)sSLContext);
            }
            if (this.ccm == null) {
                sSLContext = new PoolingClientConnectionManager(schemeRegistry);
                this.ccm = sSLContext;
                sSLContext.setMaxTotal(this.maxConnections);
                sSLContext.setDefaultMaxPerRoute(this.maxConnections);
            }
            sSLContext = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)sSLContext, (int)this.transportChannelSettings.getConfiguration().getOperationTimeout());
            HttpConnectionParams.setSoTimeout((HttpParams)sSLContext, (int)0);
            this.httpclient = new DefaultHttpClient(this.ccm, (HttpParams)sSLContext);
            if (httpsSettings.getUsername() != null && httpsSettings.getPassword() != null) {
                x509HostnameVerifier = new BasicCredentialsProvider();
                x509HostnameVerifier.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(httpsSettings.getUsername(), httpsSettings.getPassword()));
                this.httpclient.setCredentialsProvider((CredentialsProvider)x509HostnameVerifier);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            new ServiceResultException(noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            new ServiceResultException(keyManagementException);
        }
    }

    long getTimeout(ServiceRequest serviceRequest) {
        long l;
        UnsignedInteger unsignedInteger = serviceRequest.getRequestHeader() != null ? serviceRequest.getRequestHeader().getTimeoutHint() : null;
        long l2 = l = unsignedInteger != null ? unsignedInteger.longValue() : (long)this.getOperationTimeout();
        if (l == 0L) {
            l = 100000L;
        }
        return l;
    }

    @Override
    public ServiceResponse serviceRequest(ServiceRequest serviceRequest) throws ServiceResultException {
        return this.serviceRequest(serviceRequest, this.getTimeout(serviceRequest));
    }

    @Override
    public ServiceResponse serviceRequest(ServiceRequest serviceRequest, long l) throws ServiceResultException {
        AsyncResult<ServiceResponse> asyncResult = this.serviceRequestAsync(serviceRequest);
        return asyncResult.waitForResult(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest) {
        return this.serviceRequestAsync(serviceRequest, this.getTimeout(serviceRequest));
    }

    @Override
    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest, long l) {
        return this.serviceRequestAsync(serviceRequest, l, -1);
    }

    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest, long l, int n) {
        HttpsClientPendingRequest httpsClientPendingRequest = new HttpsClientPendingRequest(this, serviceRequest);
        httpsClientPendingRequest.secureChannelId = n;
        httpsClientPendingRequest.securityPolicy = this.securityPolicyUri;
        httpsClientPendingRequest.requestId = this.requestIdCounter.getAndIncrement();
        logger.debug("serviceRequestAsync: Sending message, requestId={} message={} operationTimeout={}", new Object[]{httpsClientPendingRequest.requestId, serviceRequest.getClass().getSimpleName(), l});
        logger.trace("serviceRequestAsync: message={}", (Object)serviceRequest);
        this.requests.put(httpsClientPendingRequest.requestId, httpsClientPendingRequest);
        if (httpsClientPendingRequest.startTime != 0L) {
            this.scheduleTimeoutRequestsTimer();
        }
        this.executor.execute(httpsClientPendingRequest);
        return httpsClientPendingRequest.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<HttpsClientPendingRequest> arrayList;
        this.ccm.shutdown();
        this.cancelTimeoutPendingRequestTask();
        Map<Integer, HttpsClientPendingRequest> map = this.requests;
        synchronized (map) {
            arrayList = new ArrayList<HttpsClientPendingRequest>(this.requests.values());
            logger.debug("requests.clear()");
            this.requests.clear();
        }
        if (!arrayList.isEmpty()) {
            for (HttpsClientPendingRequest httpsClientPendingRequest : arrayList) {
                httpsClientPendingRequest.cancel();
            }
        }
    }

    @Override
    public void dispose() {
        this.close();
        this.ccm = null;
        this.sr = null;
        this.httpclient = null;
        this.serializer = null;
        this.transportChannelSettings = null;
    }

    @Override
    public EnumSet<ITransportChannel.TransportChannelFeature> getSupportedFeatures() {
        return EnumSet.of(ITransportChannel.TransportChannelFeature.open, new ITransportChannel.TransportChannelFeature[]{ITransportChannel.TransportChannelFeature.openAsync, ITransportChannel.TransportChannelFeature.close, ITransportChannel.TransportChannelFeature.closeAync, ITransportChannel.TransportChannelFeature.sendRequest, ITransportChannel.TransportChannelFeature.sendRequestAsync});
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.transportChannelSettings.getDescription();
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        return this.transportChannelSettings.getConfiguration();
    }

    @Override
    public EncoderContext getMessageContext() {
        return this.encoderCtx;
    }

    @Override
    public void setOperationTimeout(int n) {
        this.transportChannelSettings.getConfiguration().setOperationTimeout(n);
    }

    @Override
    public int getOperationTimeout() {
        Integer n = this.transportChannelSettings.getConfiguration().getOperationTimeout();
        return n == null ? 0 : n;
    }

    private void scheduleTimeoutRequestsTimer() {
        HttpsClientPendingRequest httpsClientPendingRequest = this._getNextTimeoutingPendingRequest();
        if (httpsClientPendingRequest == null) {
            this.cancelTimeoutPendingRequestTask();
        } else {
            TimerTask timerTask = this.timeoutPendingRequestsTask.get();
            if (timerTask == null || timerTask.scheduledExecutionTime() > httpsClientPendingRequest.timeoutTime) {
                this.cancelTimeoutPendingRequestTask();
                timerTask = TimerUtil.schedule(this.timer, this.timeoutRun, this.executor, httpsClientPendingRequest.timeoutTime);
                if (!this.timeoutPendingRequestsTask.compareAndSet(null, timerTask)) {
                    timerTask.cancel();
                }
            }
        }
    }

    private void cancelTimeoutPendingRequestTask() {
        TimerTask timerTask = this.timeoutPendingRequestsTask.getAndSet(null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsClientPendingRequest _getNextTimeoutingPendingRequest() {
        long l = Long.MAX_VALUE;
        HttpsClientPendingRequest httpsClientPendingRequest = null;
        Map<Integer, HttpsClientPendingRequest> map = this.requests;
        synchronized (map) {
            for (HttpsClientPendingRequest httpsClientPendingRequest2 : this.requests.values()) {
                if (l <= httpsClientPendingRequest2.timeoutTime) continue;
                l = httpsClientPendingRequest2.timeoutTime;
                httpsClientPendingRequest = httpsClientPendingRequest2;
                break;
            }
        }
        return httpsClientPendingRequest;
    }
}

