/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;

public class UriUtil {
    public static final int OPC_TCP_PORT = 6000;
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int OPC_TCP_DISCOVERY_PORT = 4840;
    public static final int HTTPS_DISCOVERY_PORT = 4843;
    public static final int HTTP_DISCOVERY_PORT = 56201;
    public static final String SCHEME_OPCTCP = "opc.tcp";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final Pattern PATTERN_HTTPS = Pattern.compile("^https://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_HTTP = Pattern.compile("^http://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_OPCTCP = Pattern.compile("^opc.tcp://([^/]+)(/.*)?$", 2);
    public static final Pattern PATTERN_URI = Pattern.compile("^(\\S+)://([^/]+)(/.*)?$", 2);

    public static MessageFormat getMessageFormat(String string) throws ServiceResultException {
        if (PATTERN_OPCTCP.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        if (PATTERN_HTTPS.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        if (PATTERN_HTTP.matcher(string).matches()) {
            return MessageFormat.Binary;
        }
        throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
    }

    public static String getTransportProtocol(String string) {
        int n = string.indexOf(58);
        if (n < 1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static InetSocketAddress getSocketAddress(String string) throws ServiceResultException {
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() == null) {
                throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, "Invalid endpointUri (no scheme): " + string);
            }
            return UriUtil.getSocketAddress(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, (Throwable)uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int n;
                String[] stringArray = string.split("/+");
                String string2 = stringArray[0].split(":")[0];
                String[] stringArray2 = stringArray[1].split(":");
                String string3 = stringArray2[0];
                try {
                    n = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = UriUtil.defaultPort(string2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n = UriUtil.defaultPort(string2);
                }
                return new InetSocketAddress(string3, n);
            }
            catch (RuntimeException runtimeException) {
                throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid, (Throwable)illegalArgumentException);
            }
        }
    }

    public static InetSocketAddress getSocketAddress(URI uRI) {
        String string = uRI.getScheme().toLowerCase();
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        if (n == -1) {
            n = UriUtil.defaultPort(string);
        }
        return new InetSocketAddress(string2, n);
    }

    public static String getEndpointName(String string) {
        Matcher matcher = PATTERN_URI.matcher(string);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }

    public static int getPort(String string) {
        try {
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
            int n = inetSocketAddress.getPort();
            if (n == -1) {
                String string2 = UriUtil.getTransportProtocol(string);
                return UriUtil.defaultPort(string2);
            }
            return n;
        }
        catch (ServiceResultException serviceResultException) {
            return -1;
        }
    }

    public static int defaultPort(String string) {
        if (SCHEME_OPCTCP.equals(string)) {
            return 6000;
        }
        if (SCHEME_HTTP.equals(string)) {
            return 80;
        }
        if (SCHEME_HTTPS.equals(string)) {
            return 443;
        }
        throw new IllegalArgumentException("Unsupported protocol " + string);
    }

    public static enum MessageFormat {
        Binary,
        Xml;

    }
}

