/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport;

import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.RuntimeServiceResultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.transport.tcp.io.OpcTcpSettings;

public class TransportChannelSettings
implements Cloneable {
    EndpointDescription description;
    EndpointConfiguration configuration;
    NamespaceTable namespaceUris;
    OpcTcpSettings opctcpSettings = new OpcTcpSettings();
    HttpsSettings httpsSettings = new HttpsSettings();

    public TransportChannelSettings() {
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, Cert cert, PrivKey privKey, CertificateValidator certificateValidator, NamespaceTable namespaceTable) throws RuntimeServiceResultException {
        this.configuration = endpointConfiguration;
        this.description = endpointDescription;
        this.opctcpSettings.setClientCertificate(cert);
        this.opctcpSettings.setCertificateValidator(certificateValidator);
        this.opctcpSettings.setPrivKey(privKey);
        if (namespaceTable != null) {
            this.namespaceUris = namespaceTable;
        }
    }

    public TransportChannelSettings(EndpointDescription endpointDescription, EndpointConfiguration endpointConfiguration, KeyPair keyPair, CertificateValidator certificateValidator, X509HostnameVerifier x509HostnameVerifier) throws RuntimeServiceResultException {
        this.configuration = endpointConfiguration;
        this.description = endpointDescription;
        this.httpsSettings.setKeyPair(keyPair, new Cert[0]);
        this.httpsSettings.setCertificateValidator(certificateValidator);
        this.httpsSettings.setHostnameVerifier(x509HostnameVerifier);
    }

    public Cert getServerCertificate() {
        try {
            return this.description != null && this.description.getServerCertificate() != null && this.description.getServerCertificate().length > 0 ? new Cert(this.description.getServerCertificate()) : null;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    public EndpointDescription getDescription() {
        return this.description;
    }

    public void setDescription(EndpointDescription endpointDescription) {
        this.description = endpointDescription;
    }

    public EndpointConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EndpointConfiguration endpointConfiguration) {
        this.configuration = endpointConfiguration;
    }

    public OpcTcpSettings getOpctcpSettings() {
        return this.opctcpSettings;
    }

    public void setOpctcpSettings(OpcTcpSettings opcTcpSettings) {
        this.opctcpSettings = opcTcpSettings;
    }

    public HttpsSettings getHttpsSettings() {
        return this.httpsSettings;
    }

    public void setHttpsSettings(HttpsSettings httpsSettings) {
        this.httpsSettings = httpsSettings;
    }

    public void readFrom(TransportChannelSettings transportChannelSettings) {
        if (transportChannelSettings.description != null) {
            this.description = transportChannelSettings.description.clone();
        }
        if (transportChannelSettings.configuration != null) {
            this.configuration = transportChannelSettings.configuration.clone();
        }
        if (transportChannelSettings.opctcpSettings != null) {
            this.opctcpSettings.readFrom(transportChannelSettings.opctcpSettings);
        }
        if (transportChannelSettings.httpsSettings != null) {
            this.httpsSettings.readFrom(transportChannelSettings.httpsSettings);
        }
        if (transportChannelSettings.namespaceUris != null) {
            this.namespaceUris = transportChannelSettings.namespaceUris;
        }
    }

    public TransportChannelSettings clone() {
        TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
        if (this.description != null) {
            transportChannelSettings.setDescription(this.description.clone());
        }
        if (this.configuration != null) {
            transportChannelSettings.setConfiguration(this.configuration.clone());
        }
        if (this.opctcpSettings != null) {
            transportChannelSettings.opctcpSettings = this.opctcpSettings.clone();
        }
        if (this.httpsSettings != null) {
            transportChannelSettings.httpsSettings = this.httpsSettings.clone();
        }
        if (this.namespaceUris != null) {
            transportChannelSettings.setNamespaceUris(this.namespaceUris);
        }
        return transportChannelSettings;
    }

    public NamespaceTable getNamespaceUris() {
        return this.namespaceUris;
    }

    public void setNamespaceUris(NamespaceTable namespaceTable) {
        this.namespaceUris = namespaceTable;
    }
}

