/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.transport;

import java.net.URI;
import java.util.Arrays;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.ObjectUtils;

public class Endpoint {
    SecurityMode[] modes;
    String endpointUrl;
    private int hash;
    EndpointConfiguration endpointConfiguration;

    public Endpoint(URI uRI, SecurityMode ... securityModeArray) {
        if (securityModeArray == null || uRI == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (SecurityMode securityMode : securityModeArray) {
            if (securityMode == null) {
                throw new IllegalArgumentException("null arg");
            }
            this.hash = 13 * this.hash + securityMode.hashCode();
        }
        this.endpointUrl = uRI.toString();
        this.modes = securityModeArray;
        this.endpointConfiguration = EndpointConfiguration.defaults();
        this.hash = 13 * this.hash + uRI.hashCode();
    }

    public Endpoint(String string, SecurityMode ... securityModeArray) {
        if (securityModeArray == null || string == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (SecurityMode securityMode : securityModeArray) {
            if (securityMode == null) {
                throw new IllegalArgumentException("null arg");
            }
            this.hash = 13 * this.hash + securityMode.hashCode();
        }
        this.endpointUrl = string;
        this.modes = securityModeArray;
        this.endpointConfiguration = EndpointConfiguration.defaults();
        this.hash = 13 * this.hash + string.hashCode();
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public SecurityMode[] getSecurityModes() {
        return this.modes;
    }

    public boolean supportsSecurityMode(SecurityMode securityMode) {
        for (SecurityMode securityMode2 : this.modes) {
            if (!securityMode2.equals(securityMode)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsSecurityPolicy(SecurityPolicy securityPolicy) {
        for (SecurityMode securityMode : this.modes) {
            if (!securityMode.getSecurityPolicy().equals(securityPolicy)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)object;
        if (!ObjectUtils.objectEquals(endpoint.getEndpointUrl(), this.getEndpointUrl())) {
            return false;
        }
        return Arrays.deepEquals(this.modes, endpoint.modes);
    }

    public String toString() {
        return this.endpointUrl + " " + Arrays.toString(this.modes);
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }
}

