/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IDecoder;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.IEncoder;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;

public class SerializerComposition
implements IEncodeableSerializer {
    Map<Class<? extends IEncodeable>, IEncodeableSerializer> serializers = new HashMap<Class<? extends IEncodeable>, IEncodeableSerializer>();
    Map<ExpandedNodeId, Class<? extends IEncodeable>> idToClass = new HashMap<ExpandedNodeId, Class<? extends IEncodeable>>();
    Map<Class<? extends IEncodeable>, ExpandedNodeId> classToBinId = new HashMap<Class<? extends IEncodeable>, ExpandedNodeId>();
    Map<Class<? extends IEncodeable>, ExpandedNodeId> classToXmlId = new HashMap<Class<? extends IEncodeable>, ExpandedNodeId>();
    Set<ExpandedNodeId> nodeIds = this.idToClass.keySet();
    Set<Class<? extends IEncodeable>> classes = this.classToBinId.keySet();

    public void addSerializer(IEncodeableSerializer iEncodeableSerializer) {
        ArrayList<Class<? extends IEncodeable>> arrayList = new ArrayList<Class<? extends IEncodeable>>();
        iEncodeableSerializer.getSupportedClasses(arrayList);
        for (Class clazz : arrayList) {
            assert (this.classToBinId.get(clazz) == null);
            ExpandedNodeId expandedNodeId = iEncodeableSerializer.getNodeId(clazz, EncodeType.Binary);
            this.classToBinId.put(clazz, expandedNodeId);
            ExpandedNodeId expandedNodeId2 = iEncodeableSerializer.getNodeId(clazz, EncodeType.Xml);
            this.classToXmlId.put(clazz, expandedNodeId2);
            this.serializers.put(clazz, iEncodeableSerializer);
            if (expandedNodeId != null) {
                this.idToClass.put(expandedNodeId, clazz);
            }
            if (expandedNodeId2 != null) {
                this.idToClass.put(expandedNodeId2, clazz);
            }
            try {
                ExpandedNodeId expandedNodeId3 = iEncodeableSerializer.getNodeId(clazz, null);
                if (expandedNodeId3 == null) continue;
                this.idToClass.put(expandedNodeId3, clazz);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void putEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        IEncodeableSerializer iEncodeableSerializer = this.serializers.get(clazz);
        if (iEncodeableSerializer == null) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        iEncodeableSerializer.putEncodeable(clazz, iEncodeable, iEncoder);
    }

    @Override
    public void calcEncodeable(Class<? extends IEncodeable> clazz, IEncodeable iEncodeable, IEncoder iEncoder) throws EncodingException {
        IEncodeableSerializer iEncodeableSerializer = this.serializers.get(clazz);
        if (iEncodeableSerializer == null) {
            throw new EncodingException("Cannot encode " + clazz);
        }
        iEncodeableSerializer.calcEncodeable(clazz, iEncodeable, iEncoder);
    }

    @Override
    public IEncodeable getEncodeable(Class<? extends IEncodeable> clazz, IDecoder iDecoder) throws DecodingException {
        IEncodeableSerializer iEncodeableSerializer = this.serializers.get(clazz);
        if (iEncodeableSerializer == null) {
            throw new DecodingException("Cannot decode " + clazz);
        }
        return iEncodeableSerializer.getEncodeable(clazz, iDecoder);
    }

    @Override
    public Class<? extends IEncodeable> getClass(ExpandedNodeId expandedNodeId) {
        return this.idToClass.get(expandedNodeId);
    }

    @Override
    public ExpandedNodeId getNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) {
        if (encodeType == EncodeType.Binary) {
            return this.classToBinId.get(clazz);
        }
        if (encodeType == EncodeType.Xml) {
            return this.classToXmlId.get(clazz);
        }
        return null;
    }

    @Override
    public void getSupportedClasses(Collection<Class<? extends IEncodeable>> collection) {
        collection.addAll(this.classes);
    }

    @Override
    public void getSupportedNodeIds(Collection<ExpandedNodeId> collection) {
        collection.addAll(this.nodeIds);
    }
}

