/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding.binary;

import org.opcfoundation.ua.core.IdType;

public enum NodeIdEncoding {
    TwoByte(0, IdType.Numeric),
    FourByte(1, IdType.Numeric),
    Numeric(2, IdType.Numeric),
    String(3, IdType.String),
    Guid(4, IdType.Guid),
    ByteString(5, IdType.String);

    private final byte bits;
    private final IdType identifierType;

    private NodeIdEncoding(byte by, IdType idType) {
        this.bits = by;
        this.identifierType = idType;
    }

    public byte getBits() {
        return this.bits;
    }

    public IdType toIdentifierType() {
        return this.identifierType;
    }

    public static NodeIdEncoding getNodeIdEncoding(int n) {
        if (n == TwoByte.getBits()) {
            return TwoByte;
        }
        if (n == FourByte.getBits()) {
            return FourByte;
        }
        if (n == Numeric.getBits()) {
            return Numeric;
        }
        if (n == String.getBits()) {
            return String;
        }
        if (n == Guid.getBits()) {
            return Guid;
        }
        if (n == ByteString.getBits()) {
            return ByteString;
        }
        return null;
    }
}

