/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.encoding;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncodeType;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.encoding.binary.IEncodeableSerializer;
import org.opcfoundation.ua.utils.StackUtils;

public class EncoderContext {
    private static EncoderContext defaultInstance = new EncoderContext(NamespaceTable.getDefaultInstance(), null, StackUtils.getDefaultSerializer());
    public NamespaceTable namespaceTable;
    public ServerTable serverTable;
    public IEncodeableSerializer encodeableSerializer;
    public int maxMessageSize = 0;
    public int maxStringLength = 0;
    public int maxByteStringLength = 0;
    public int maxArrayLength = 0;

    public static EncoderContext getDefaultInstance() {
        return defaultInstance;
    }

    public Object decode(ExtensionObject[] extensionObjectArray) throws DecodingException {
        return this.decode(extensionObjectArray, null);
    }

    public Object decode(ExtensionObject[] extensionObjectArray, NamespaceTable namespaceTable) throws DecodingException {
        int n = extensionObjectArray.length;
        Structure[] structureArray = new Structure[n];
        for (int i = 0; i < n; ++i) {
            ExtensionObject extensionObject = extensionObjectArray[i];
            if (extensionObject == null) continue;
            structureArray[i] = (Structure)extensionObject.decode(this, namespaceTable);
        }
        Structure[] structureArray2 = structureArray;
        if (n > 0) {
            Class<?> clazz = null;
            for (int i = 0; i < n; ++i) {
                if (structureArray[i] == null) continue;
                Class<?> clazz2 = structureArray[i].getClass();
                if (clazz == null) {
                    clazz = clazz2;
                    continue;
                }
                if (clazz2.isAssignableFrom(clazz)) continue;
                if (clazz.isAssignableFrom(clazz2)) {
                    clazz = clazz2;
                    continue;
                }
                clazz = null;
                break;
            }
            if (clazz != null) {
                structureArray2 = Arrays.copyOf(structureArray, n, ((Structure[])Array.newInstance(clazz, 0)).getClass());
            }
        }
        return structureArray2;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, IEncodeableSerializer iEncodeableSerializer, int n) {
        this.encodeableSerializer = iEncodeableSerializer;
        this.namespaceTable = namespaceTable;
        this.serverTable = serverTable;
        this.maxMessageSize = n;
    }

    public EncoderContext(NamespaceTable namespaceTable, ServerTable serverTable, IEncodeableSerializer iEncodeableSerializer) {
        this.encodeableSerializer = iEncodeableSerializer;
        this.namespaceTable = namespaceTable;
        this.serverTable = serverTable;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int n) {
        this.maxMessageSize = n;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public void setNamespaceTable(NamespaceTable namespaceTable) {
        this.namespaceTable = namespaceTable;
    }

    public NodeId getEncodeableNodeId(Class<? extends IEncodeable> clazz, EncodeType encodeType) throws ServiceResultException {
        return this.namespaceTable.toNodeId(this.encodeableSerializer.getNodeId(clazz, encodeType));
    }

    public ServerTable getServerTable() {
        return this.serverTable;
    }

    public void setServerTable(ServerTable serverTable) {
        this.serverTable = serverTable;
    }

    public IEncodeableSerializer getEncodeableSerializer() {
        return this.encodeableSerializer;
    }

    public Class<? extends IEncodeable> getEncodeableClass(NodeId nodeId) {
        return this.encodeableSerializer.getClass(this.namespaceTable.toExpandedNodeId(nodeId));
    }

    public void setEncodeableSerializer(IEncodeableSerializer iEncodeableSerializer) {
        this.encodeableSerializer = iEncodeableSerializer;
    }

    public NodeId toNodeId(ExpandedNodeId expandedNodeId) throws EncodingException {
        try {
            return this.namespaceTable.toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new EncodingException("Could not get namespace index for given id");
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int n) {
        this.maxStringLength = n;
    }

    public int getMaxByteStringLength() {
        return this.maxByteStringLength;
    }

    public void setMaxByteStringLength(int n) {
        this.maxByteStringLength = n;
    }

    public int getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public void setMaxArrayLength(int n) {
        this.maxArrayLength = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   namespaceTable = " + this.namespaceTable + "\n");
        stringBuilder.append("   serverTable = " + this.serverTable + "\n");
        stringBuilder.append("   maxMessageSize = " + this.maxMessageSize + "\n");
        stringBuilder.append("   maxStringLength = " + this.maxStringLength + "\n");
        stringBuilder.append("   maxByteStringLength = " + this.maxByteStringLength + "\n");
        stringBuilder.append("   maxArrayLength = " + this.maxArrayLength + "\n");
        return stringBuilder.toString();
    }
}

