/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.WriteValue;
import org.opcfoundation.ua.utils.ObjectUtils;

public class WriteRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.WriteRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.WriteRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.WriteRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected WriteValue[] NodesToWrite;

    public WriteRequest() {
    }

    public WriteRequest(RequestHeader requestHeader, WriteValue[] writeValueArray) {
        this.RequestHeader = requestHeader;
        this.NodesToWrite = writeValueArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public WriteValue[] getNodesToWrite() {
        return this.NodesToWrite;
    }

    public void setNodesToWrite(WriteValue[] writeValueArray) {
        this.NodesToWrite = writeValueArray;
    }

    public WriteRequest clone() {
        WriteRequest writeRequest = new WriteRequest();
        RequestHeader requestHeader = writeRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        if (this.NodesToWrite != null) {
            writeRequest.NodesToWrite = new WriteValue[this.NodesToWrite.length];
            for (int i = 0; i < this.NodesToWrite.length; ++i) {
                writeRequest.NodesToWrite[i] = this.NodesToWrite[i].clone();
            }
        }
        return writeRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WriteRequest writeRequest = (WriteRequest)object;
        if (this.RequestHeader == null ? writeRequest.RequestHeader != null : !this.RequestHeader.equals(writeRequest.RequestHeader)) {
            return false;
        }
        return !(this.NodesToWrite == null ? writeRequest.NodesToWrite != null : !Arrays.equals(this.NodesToWrite, writeRequest.NodesToWrite));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.NodesToWrite == null ? 0 : Arrays.hashCode(this.NodesToWrite));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

