/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.core.TypeNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class VariableTypeNode
extends TypeNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.VariableTypeNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.VariableTypeNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.VariableTypeNode_Encoding_DefaultXml);
    protected Variant Value;
    protected NodeId DataType;
    protected Integer ValueRank;
    protected UnsignedInteger[] ArrayDimensions;
    protected Boolean IsAbstract;

    public VariableTypeNode() {
    }

    public VariableTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Variant variant, NodeId nodeId2, Integer n, UnsignedInteger[] unsignedIntegerArray, Boolean bl) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.Value = variant;
        this.DataType = nodeId2;
        this.ValueRank = n;
        this.ArrayDimensions = unsignedIntegerArray;
        this.IsAbstract = bl;
    }

    public Variant getValue() {
        return this.Value;
    }

    public void setValue(Variant variant) {
        this.Value = variant;
    }

    public NodeId getDataType() {
        return this.DataType;
    }

    public void setDataType(NodeId nodeId) {
        this.DataType = nodeId;
    }

    public Integer getValueRank() {
        return this.ValueRank;
    }

    public void setValueRank(Integer n) {
        this.ValueRank = n;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.ArrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.ArrayDimensions = unsignedIntegerArray;
    }

    public Boolean getIsAbstract() {
        return this.IsAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.IsAbstract = bl;
    }

    @Override
    public VariableTypeNode clone() {
        VariableTypeNode variableTypeNode = new VariableTypeNode();
        variableTypeNode.NodeId = this.NodeId;
        variableTypeNode.NodeClass = this.NodeClass;
        variableTypeNode.BrowseName = this.BrowseName;
        variableTypeNode.DisplayName = this.DisplayName;
        variableTypeNode.Description = this.Description;
        variableTypeNode.WriteMask = this.WriteMask;
        variableTypeNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            variableTypeNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                variableTypeNode.References[i] = this.References[i].clone();
            }
        }
        variableTypeNode.Value = this.Value;
        variableTypeNode.DataType = this.DataType;
        variableTypeNode.ValueRank = this.ValueRank;
        variableTypeNode.ArrayDimensions = this.ArrayDimensions == null ? null : (UnsignedInteger[])this.ArrayDimensions.clone();
        variableTypeNode.IsAbstract = this.IsAbstract;
        return variableTypeNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VariableTypeNode variableTypeNode = (VariableTypeNode)object;
        if (this.NodeId == null ? variableTypeNode.NodeId != null : !this.NodeId.equals(variableTypeNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? variableTypeNode.NodeClass != null : !this.NodeClass.equals(variableTypeNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? variableTypeNode.BrowseName != null : !this.BrowseName.equals(variableTypeNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? variableTypeNode.DisplayName != null : !this.DisplayName.equals(variableTypeNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? variableTypeNode.Description != null : !this.Description.equals(variableTypeNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? variableTypeNode.WriteMask != null : !this.WriteMask.equals(variableTypeNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? variableTypeNode.UserWriteMask != null : !this.UserWriteMask.equals(variableTypeNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? variableTypeNode.References != null : !Arrays.equals(this.References, variableTypeNode.References)) {
            return false;
        }
        if (this.Value == null ? variableTypeNode.Value != null : !this.Value.equals(variableTypeNode.Value)) {
            return false;
        }
        if (this.DataType == null ? variableTypeNode.DataType != null : !this.DataType.equals(variableTypeNode.DataType)) {
            return false;
        }
        if (this.ValueRank == null ? variableTypeNode.ValueRank != null : !this.ValueRank.equals(variableTypeNode.ValueRank)) {
            return false;
        }
        if (this.ArrayDimensions == null ? variableTypeNode.ArrayDimensions != null : !Arrays.equals(this.ArrayDimensions, variableTypeNode.ArrayDimensions)) {
            return false;
        }
        return !(this.IsAbstract == null ? variableTypeNode.IsAbstract != null : !this.IsAbstract.equals(variableTypeNode.IsAbstract));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.Value == null ? 0 : this.Value.hashCode());
        n = 31 * n + (this.DataType == null ? 0 : this.DataType.hashCode());
        n = 31 * n + (this.ValueRank == null ? 0 : this.ValueRank.hashCode());
        n = 31 * n + (this.ArrayDimensions == null ? 0 : Arrays.hashCode(this.ArrayDimensions));
        n = 31 * n + (this.IsAbstract == null ? 0 : this.IsAbstract.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "VariableTypeNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

