/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.InstanceNode;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class VariableNode
extends InstanceNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.VariableNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.VariableNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.VariableNode_Encoding_DefaultXml);
    protected Variant Value;
    protected NodeId DataType;
    protected Integer ValueRank;
    protected UnsignedInteger[] ArrayDimensions;
    protected UnsignedByte AccessLevel;
    protected UnsignedByte UserAccessLevel;
    protected Double MinimumSamplingInterval;
    protected Boolean Historizing;

    public VariableNode() {
    }

    public VariableNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Variant variant, NodeId nodeId2, Integer n, UnsignedInteger[] unsignedIntegerArray, UnsignedByte unsignedByte, UnsignedByte unsignedByte2, Double d, Boolean bl) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.Value = variant;
        this.DataType = nodeId2;
        this.ValueRank = n;
        this.ArrayDimensions = unsignedIntegerArray;
        this.AccessLevel = unsignedByte;
        this.UserAccessLevel = unsignedByte2;
        this.MinimumSamplingInterval = d;
        this.Historizing = bl;
    }

    public Variant getValue() {
        return this.Value;
    }

    public void setValue(Variant variant) {
        this.Value = variant;
    }

    public NodeId getDataType() {
        return this.DataType;
    }

    public void setDataType(NodeId nodeId) {
        this.DataType = nodeId;
    }

    public Integer getValueRank() {
        return this.ValueRank;
    }

    public void setValueRank(Integer n) {
        this.ValueRank = n;
    }

    public UnsignedInteger[] getArrayDimensions() {
        return this.ArrayDimensions;
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.ArrayDimensions = unsignedIntegerArray;
    }

    public UnsignedByte getAccessLevel() {
        return this.AccessLevel;
    }

    public void setAccessLevel(UnsignedByte unsignedByte) {
        this.AccessLevel = unsignedByte;
    }

    public UnsignedByte getUserAccessLevel() {
        return this.UserAccessLevel;
    }

    public void setUserAccessLevel(UnsignedByte unsignedByte) {
        this.UserAccessLevel = unsignedByte;
    }

    public Double getMinimumSamplingInterval() {
        return this.MinimumSamplingInterval;
    }

    public void setMinimumSamplingInterval(Double d) {
        this.MinimumSamplingInterval = d;
    }

    public Boolean getHistorizing() {
        return this.Historizing;
    }

    public void setHistorizing(Boolean bl) {
        this.Historizing = bl;
    }

    @Override
    public VariableNode clone() {
        VariableNode variableNode = new VariableNode();
        variableNode.NodeId = this.NodeId;
        variableNode.NodeClass = this.NodeClass;
        variableNode.BrowseName = this.BrowseName;
        variableNode.DisplayName = this.DisplayName;
        variableNode.Description = this.Description;
        variableNode.WriteMask = this.WriteMask;
        variableNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            variableNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                variableNode.References[i] = this.References[i].clone();
            }
        }
        variableNode.Value = this.Value;
        variableNode.DataType = this.DataType;
        variableNode.ValueRank = this.ValueRank;
        variableNode.ArrayDimensions = this.ArrayDimensions == null ? null : (UnsignedInteger[])this.ArrayDimensions.clone();
        variableNode.AccessLevel = this.AccessLevel;
        variableNode.UserAccessLevel = this.UserAccessLevel;
        variableNode.MinimumSamplingInterval = this.MinimumSamplingInterval;
        variableNode.Historizing = this.Historizing;
        return variableNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VariableNode variableNode = (VariableNode)object;
        if (this.NodeId == null ? variableNode.NodeId != null : !this.NodeId.equals(variableNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? variableNode.NodeClass != null : !this.NodeClass.equals(variableNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? variableNode.BrowseName != null : !this.BrowseName.equals(variableNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? variableNode.DisplayName != null : !this.DisplayName.equals(variableNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? variableNode.Description != null : !this.Description.equals(variableNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? variableNode.WriteMask != null : !this.WriteMask.equals(variableNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? variableNode.UserWriteMask != null : !this.UserWriteMask.equals(variableNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? variableNode.References != null : !Arrays.equals(this.References, variableNode.References)) {
            return false;
        }
        if (this.Value == null ? variableNode.Value != null : !this.Value.equals(variableNode.Value)) {
            return false;
        }
        if (this.DataType == null ? variableNode.DataType != null : !this.DataType.equals(variableNode.DataType)) {
            return false;
        }
        if (this.ValueRank == null ? variableNode.ValueRank != null : !this.ValueRank.equals(variableNode.ValueRank)) {
            return false;
        }
        if (this.ArrayDimensions == null ? variableNode.ArrayDimensions != null : !Arrays.equals(this.ArrayDimensions, variableNode.ArrayDimensions)) {
            return false;
        }
        if (this.AccessLevel == null ? variableNode.AccessLevel != null : !this.AccessLevel.equals(variableNode.AccessLevel)) {
            return false;
        }
        if (this.UserAccessLevel == null ? variableNode.UserAccessLevel != null : !this.UserAccessLevel.equals(variableNode.UserAccessLevel)) {
            return false;
        }
        if (this.MinimumSamplingInterval == null ? variableNode.MinimumSamplingInterval != null : !this.MinimumSamplingInterval.equals(variableNode.MinimumSamplingInterval)) {
            return false;
        }
        return !(this.Historizing == null ? variableNode.Historizing != null : !this.Historizing.equals(variableNode.Historizing));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.Value == null ? 0 : this.Value.hashCode());
        n = 31 * n + (this.DataType == null ? 0 : this.DataType.hashCode());
        n = 31 * n + (this.ValueRank == null ? 0 : this.ValueRank.hashCode());
        n = 31 * n + (this.ArrayDimensions == null ? 0 : Arrays.hashCode(this.ArrayDimensions));
        n = 31 * n + (this.AccessLevel == null ? 0 : this.AccessLevel.hashCode());
        n = 31 * n + (this.UserAccessLevel == null ? 0 : this.UserAccessLevel.hashCode());
        n = 31 * n + (this.MinimumSamplingInterval == null ? 0 : this.MinimumSamplingInterval.hashCode());
        n = 31 * n + (this.Historizing == null ? 0 : this.Historizing.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "VariableNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

