/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.UserTokenType;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.ObjectUtils;

public class UserTokenPolicy
implements Structure,
Cloneable {
    public static final UserTokenPolicy ANONYMOUS = new UserTokenPolicy("anonymous", UserTokenType.Anonymous, null, null, null);
    public static final UserTokenPolicy SECURE_USERNAME_PASSWORD = new UserTokenPolicy("username_basic128", UserTokenType.UserName, null, null, SecurityPolicy.BASIC128RSA15.getPolicyUri());
    public static final UserTokenPolicy SECURE_USERNAME_PASSWORD_BASIC256 = new UserTokenPolicy("username_basic256", UserTokenType.UserName, null, null, SecurityPolicy.BASIC256.getPolicyUri());
    public static final UserTokenPolicy SECURE_CERTIFICATE = new UserTokenPolicy("certificate_basic128", UserTokenType.Certificate, null, null, SecurityPolicy.BASIC128RSA15.getPolicyUri());
    public static final UserTokenPolicy SECURE_CERTIFICATE_BASIC256 = new UserTokenPolicy("certificate_basic256", UserTokenType.Certificate, null, null, SecurityPolicy.BASIC256.getPolicyUri());
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.UserTokenPolicy);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.UserTokenPolicy_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.UserTokenPolicy_Encoding_DefaultXml);
    protected String PolicyId;
    protected UserTokenType TokenType;
    protected String IssuedTokenType;
    protected String IssuerEndpointUrl;
    protected String SecurityPolicyUri;

    public UserTokenPolicy() {
    }

    public UserTokenPolicy(String string, UserTokenType userTokenType, String string2, String string3, String string4) {
        this.PolicyId = string;
        this.TokenType = userTokenType;
        this.IssuedTokenType = string2;
        this.IssuerEndpointUrl = string3;
        this.SecurityPolicyUri = string4;
    }

    public String getPolicyId() {
        return this.PolicyId;
    }

    public void setPolicyId(String string) {
        this.PolicyId = string;
    }

    public UserTokenType getTokenType() {
        return this.TokenType;
    }

    public void setTokenType(UserTokenType userTokenType) {
        this.TokenType = userTokenType;
    }

    public String getIssuedTokenType() {
        return this.IssuedTokenType;
    }

    public void setIssuedTokenType(String string) {
        this.IssuedTokenType = string;
    }

    public String getIssuerEndpointUrl() {
        return this.IssuerEndpointUrl;
    }

    public void setIssuerEndpointUrl(String string) {
        this.IssuerEndpointUrl = string;
    }

    public String getSecurityPolicyUri() {
        return this.SecurityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.SecurityPolicyUri = string;
    }

    public UserTokenPolicy clone() {
        UserTokenPolicy userTokenPolicy = new UserTokenPolicy();
        userTokenPolicy.PolicyId = this.PolicyId;
        userTokenPolicy.TokenType = this.TokenType;
        userTokenPolicy.IssuedTokenType = this.IssuedTokenType;
        userTokenPolicy.IssuerEndpointUrl = this.IssuerEndpointUrl;
        userTokenPolicy.SecurityPolicyUri = this.SecurityPolicyUri;
        return userTokenPolicy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserTokenPolicy userTokenPolicy = (UserTokenPolicy)object;
        if (this.PolicyId == null ? userTokenPolicy.PolicyId != null : !this.PolicyId.equals(userTokenPolicy.PolicyId)) {
            return false;
        }
        if (this.TokenType == null ? userTokenPolicy.TokenType != null : !this.TokenType.equals(userTokenPolicy.TokenType)) {
            return false;
        }
        if (this.IssuedTokenType == null ? userTokenPolicy.IssuedTokenType != null : !this.IssuedTokenType.equals(userTokenPolicy.IssuedTokenType)) {
            return false;
        }
        if (this.IssuerEndpointUrl == null ? userTokenPolicy.IssuerEndpointUrl != null : !this.IssuerEndpointUrl.equals(userTokenPolicy.IssuerEndpointUrl)) {
            return false;
        }
        return !(this.SecurityPolicyUri == null ? userTokenPolicy.SecurityPolicyUri != null : !this.SecurityPolicyUri.equals(userTokenPolicy.SecurityPolicyUri));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.PolicyId == null ? 0 : this.PolicyId.hashCode());
        n = 31 * n + (this.TokenType == null ? 0 : this.TokenType.hashCode());
        n = 31 * n + (this.IssuedTokenType == null ? 0 : this.IssuedTokenType.hashCode());
        n = 31 * n + (this.IssuerEndpointUrl == null ? 0 : this.IssuerEndpointUrl.hashCode());
        n = 31 * n + (this.SecurityPolicyUri == null ? 0 : this.SecurityPolicyUri.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "UserTokenPolicy: " + ObjectUtils.printFieldsDeep(this);
    }
}

