/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum TrustListMasks implements Enumeration
{
    None(0),
    TrustedCertificates(1),
    TrustedCrls(2),
    IssuerCertificates(4),
    IssuerCrls(8),
    All(15);

    public static final NodeId ID;
    public static EnumSet<TrustListMasks> NONE;
    public static EnumSet<TrustListMasks> ALL;
    private final int value;
    private static final Map<Integer, TrustListMasks> map;

    private TrustListMasks(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static TrustListMasks valueOf(int n) {
        return map.get(n);
    }

    public static TrustListMasks valueOf(Integer n) {
        return n == null ? null : TrustListMasks.valueOf((int)n);
    }

    public static TrustListMasks valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : TrustListMasks.valueOf(unsignedInteger.intValue());
    }

    public static TrustListMasks[] valueOf(int[] nArray) {
        TrustListMasks[] trustListMasksArray = new TrustListMasks[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            trustListMasksArray[i] = TrustListMasks.valueOf(nArray[i]);
        }
        return trustListMasksArray;
    }

    public static TrustListMasks[] valueOf(Integer[] integerArray) {
        TrustListMasks[] trustListMasksArray = new TrustListMasks[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            trustListMasksArray[i] = TrustListMasks.valueOf(integerArray[i]);
        }
        return trustListMasksArray;
    }

    public static TrustListMasks[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        TrustListMasks[] trustListMasksArray = new TrustListMasks[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            trustListMasksArray[i] = TrustListMasks.valueOf(unsignedIntegerArray[i]);
        }
        return trustListMasksArray;
    }

    public static UnsignedInteger getMask(TrustListMasks ... trustListMasksArray) {
        int n = 0;
        for (TrustListMasks trustListMasks : trustListMasksArray) {
            n |= trustListMasks.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<TrustListMasks> collection) {
        int n = 0;
        for (TrustListMasks trustListMasks : collection) {
            n |= trustListMasks.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<TrustListMasks> getSet(UnsignedInteger unsignedInteger) {
        return TrustListMasks.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<TrustListMasks> getSet(int n) {
        ArrayList<TrustListMasks> arrayList = new ArrayList<TrustListMasks>();
        for (TrustListMasks trustListMasks : TrustListMasks.values()) {
            if ((n & trustListMasks.value) != trustListMasks.value) continue;
            arrayList.add(trustListMasks);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.TrustListMasks;
        NONE = EnumSet.noneOf(TrustListMasks.class);
        ALL = EnumSet.allOf(TrustListMasks.class);
        map = new HashMap<Integer, TrustListMasks>();
        for (TrustListMasks trustListMasks : TrustListMasks.values()) {
            map.put(trustListMasks.value, trustListMasks);
        }
    }
}

