/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TrustListDataType
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TrustListDataType);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TrustListDataType_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TrustListDataType_Encoding_DefaultXml);
    protected UnsignedInteger SpecifiedLists;
    protected byte[][] TrustedCertificates;
    protected byte[][] TrustedCrls;
    protected byte[][] IssuerCertificates;
    protected byte[][] IssuerCrls;

    public TrustListDataType() {
    }

    public TrustListDataType(UnsignedInteger unsignedInteger, byte[][] byArray, byte[][] byArray2, byte[][] byArray3, byte[][] byArray4) {
        this.SpecifiedLists = unsignedInteger;
        this.TrustedCertificates = byArray;
        this.TrustedCrls = byArray2;
        this.IssuerCertificates = byArray3;
        this.IssuerCrls = byArray4;
    }

    public UnsignedInteger getSpecifiedLists() {
        return this.SpecifiedLists;
    }

    public void setSpecifiedLists(UnsignedInteger unsignedInteger) {
        this.SpecifiedLists = unsignedInteger;
    }

    public byte[][] getTrustedCertificates() {
        return this.TrustedCertificates;
    }

    public void setTrustedCertificates(byte[][] byArray) {
        this.TrustedCertificates = byArray;
    }

    public byte[][] getTrustedCrls() {
        return this.TrustedCrls;
    }

    public void setTrustedCrls(byte[][] byArray) {
        this.TrustedCrls = byArray;
    }

    public byte[][] getIssuerCertificates() {
        return this.IssuerCertificates;
    }

    public void setIssuerCertificates(byte[][] byArray) {
        this.IssuerCertificates = byArray;
    }

    public byte[][] getIssuerCrls() {
        return this.IssuerCrls;
    }

    public void setIssuerCrls(byte[][] byArray) {
        this.IssuerCrls = byArray;
    }

    public TrustListDataType clone() {
        TrustListDataType trustListDataType = new TrustListDataType();
        trustListDataType.SpecifiedLists = this.SpecifiedLists;
        trustListDataType.TrustedCertificates = this.TrustedCertificates == null ? (byte[][])null : (byte[][])this.TrustedCertificates.clone();
        trustListDataType.TrustedCrls = this.TrustedCrls == null ? (byte[][])null : (byte[][])this.TrustedCrls.clone();
        trustListDataType.IssuerCertificates = this.IssuerCertificates == null ? (byte[][])null : (byte[][])this.IssuerCertificates.clone();
        trustListDataType.IssuerCrls = this.IssuerCrls == null ? (byte[][])null : (byte[][])this.IssuerCrls.clone();
        return trustListDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TrustListDataType trustListDataType = (TrustListDataType)object;
        if (this.SpecifiedLists == null ? trustListDataType.SpecifiedLists != null : !this.SpecifiedLists.equals(trustListDataType.SpecifiedLists)) {
            return false;
        }
        if (this.TrustedCertificates == null ? trustListDataType.TrustedCertificates != null : !Arrays.equals((Object[])this.TrustedCertificates, (Object[])trustListDataType.TrustedCertificates)) {
            return false;
        }
        if (this.TrustedCrls == null ? trustListDataType.TrustedCrls != null : !Arrays.equals((Object[])this.TrustedCrls, (Object[])trustListDataType.TrustedCrls)) {
            return false;
        }
        if (this.IssuerCertificates == null ? trustListDataType.IssuerCertificates != null : !Arrays.equals((Object[])this.IssuerCertificates, (Object[])trustListDataType.IssuerCertificates)) {
            return false;
        }
        return !(this.IssuerCrls == null ? trustListDataType.IssuerCrls != null : !Arrays.equals((Object[])this.IssuerCrls, (Object[])trustListDataType.IssuerCrls));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.SpecifiedLists == null ? 0 : this.SpecifiedLists.hashCode());
        n = 31 * n + (this.TrustedCertificates == null ? 0 : Arrays.hashCode((Object[])this.TrustedCertificates));
        n = 31 * n + (this.TrustedCrls == null ? 0 : Arrays.hashCode((Object[])this.TrustedCrls));
        n = 31 * n + (this.IssuerCertificates == null ? 0 : Arrays.hashCode((Object[])this.IssuerCertificates));
        n = 31 * n + (this.IssuerCrls == null ? 0 : Arrays.hashCode((Object[])this.IssuerCrls));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "TrustListDataType: " + ObjectUtils.printFieldsDeep(this);
    }
}

