/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class TransferSubscriptionsRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.TransferSubscriptionsRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.TransferSubscriptionsRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.TransferSubscriptionsRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected UnsignedInteger[] SubscriptionIds;
    protected Boolean SendInitialValues;

    public TransferSubscriptionsRequest() {
    }

    public TransferSubscriptionsRequest(RequestHeader requestHeader, UnsignedInteger[] unsignedIntegerArray, Boolean bl) {
        this.RequestHeader = requestHeader;
        this.SubscriptionIds = unsignedIntegerArray;
        this.SendInitialValues = bl;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public UnsignedInteger[] getSubscriptionIds() {
        return this.SubscriptionIds;
    }

    public void setSubscriptionIds(UnsignedInteger[] unsignedIntegerArray) {
        this.SubscriptionIds = unsignedIntegerArray;
    }

    public Boolean getSendInitialValues() {
        return this.SendInitialValues;
    }

    public void setSendInitialValues(Boolean bl) {
        this.SendInitialValues = bl;
    }

    public TransferSubscriptionsRequest clone() {
        TransferSubscriptionsRequest transferSubscriptionsRequest = new TransferSubscriptionsRequest();
        transferSubscriptionsRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        transferSubscriptionsRequest.SubscriptionIds = this.SubscriptionIds == null ? null : (UnsignedInteger[])this.SubscriptionIds.clone();
        transferSubscriptionsRequest.SendInitialValues = this.SendInitialValues;
        return transferSubscriptionsRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TransferSubscriptionsRequest transferSubscriptionsRequest = (TransferSubscriptionsRequest)object;
        if (this.RequestHeader == null ? transferSubscriptionsRequest.RequestHeader != null : !this.RequestHeader.equals(transferSubscriptionsRequest.RequestHeader)) {
            return false;
        }
        if (this.SubscriptionIds == null ? transferSubscriptionsRequest.SubscriptionIds != null : !Arrays.equals(this.SubscriptionIds, transferSubscriptionsRequest.SubscriptionIds)) {
            return false;
        }
        return !(this.SendInitialValues == null ? transferSubscriptionsRequest.SendInitialValues != null : !this.SendInitialValues.equals(transferSubscriptionsRequest.SendInitialValues));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.SubscriptionIds == null ? 0 : Arrays.hashCode(this.SubscriptionIds));
        n = 31 * n + (this.SendInitialValues == null ? 0 : this.SendInitialValues.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

