/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class SignatureData
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.SignatureData);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.SignatureData_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.SignatureData_Encoding_DefaultXml);
    protected String Algorithm;
    protected byte[] Signature;

    public SignatureData() {
    }

    public SignatureData(String string, byte[] byArray) {
        this.Algorithm = string;
        this.Signature = byArray;
    }

    public String getAlgorithm() {
        return this.Algorithm;
    }

    public void setAlgorithm(String string) {
        this.Algorithm = string;
    }

    public byte[] getSignature() {
        return this.Signature;
    }

    public void setSignature(byte[] byArray) {
        this.Signature = byArray;
    }

    public SignatureData clone() {
        SignatureData signatureData = new SignatureData();
        signatureData.Algorithm = this.Algorithm;
        signatureData.Signature = this.Signature;
        return signatureData;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SignatureData signatureData = (SignatureData)object;
        if (this.Algorithm == null ? signatureData.Algorithm != null : !this.Algorithm.equals(signatureData.Algorithm)) {
            return false;
        }
        return !(this.Signature == null ? signatureData.Signature != null : !this.Signature.equals(signatureData.Signature));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Algorithm == null ? 0 : this.Algorithm.hashCode());
        n = 31 * n + (this.Signature == null ? 0 : this.Signature.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "SignatureData: " + ObjectUtils.printFieldsDeep(this);
    }
}

