/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.StatusCodes;

public class ServiceFault
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ServiceFault);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ServiceFault_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ServiceFault_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;

    public static ServiceFault createServiceFault(UnsignedInteger unsignedInteger) {
        ResponseHeader responseHeader = new ResponseHeader();
        ServiceFault serviceFault = new ServiceFault(responseHeader);
        responseHeader.setServiceResult(new StatusCode(unsignedInteger));
        responseHeader.setTimestamp(new DateTime());
        return serviceFault;
    }

    public static ServiceFault toServiceFault(Throwable throwable) {
        ResponseHeader responseHeader = new ResponseHeader();
        ServiceFault serviceFault = new ServiceFault(responseHeader);
        responseHeader.setServiceResult(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_InternalError));
        responseHeader.setTimestamp(new DateTime());
        ArrayList<String> arrayList = new ArrayList<String>();
        DiagnosticInfo diagnosticInfo = null;
        while (throwable != null) {
            if (diagnosticInfo == null) {
                diagnosticInfo = new DiagnosticInfo();
                responseHeader.setServiceDiagnostics(diagnosticInfo);
            } else {
                DiagnosticInfo diagnosticInfo2 = diagnosticInfo;
                diagnosticInfo = new DiagnosticInfo();
                diagnosticInfo2.setInnerDiagnosticInfo(diagnosticInfo);
            }
            diagnosticInfo.setStringTable(arrayList);
            diagnosticInfo.setLocalizedTextStr(throwable instanceof ServiceResultException ? throwable.getMessage() : throwable.toString());
            StringWriter stringWriter = new StringWriter(100);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                printWriter.println("\tat " + stackTraceElement);
            }
            diagnosticInfo.setAdditionalInfo(stringWriter.toString());
            diagnosticInfo.setInnerStatusCode(throwable instanceof ServiceResultException ? ((ServiceResultException)throwable).getStatusCode() : new StatusCode(StatusCodes.Bad_InternalError));
            throwable = throwable.getCause();
        }
        responseHeader.setStringTable(arrayList.toArray(new String[arrayList.size()]));
        return serviceFault;
    }

    public ServiceFault() {
    }

    public ServiceFault(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public ServiceFault clone() {
        ServiceFault serviceFault = new ServiceFault();
        serviceFault.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        return serviceFault;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServiceFault serviceFault = (ServiceFault)object;
        return !(this.ResponseHeader == null ? serviceFault.ResponseHeader != null : !this.ResponseHeader.equals(serviceFault.ResponseHeader));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        ResponseHeader responseHeader = this.getResponseHeader();
        if (responseHeader == null) {
            return "ServiceFault";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ServiceFault: ");
        StatusCode statusCode = responseHeader.getServiceResult();
        if (statusCode != null) {
            stringBuilder.append(statusCode.toString());
        }
        stringBuilder.append('\n');
        DiagnosticInfo diagnosticInfo = responseHeader.getServiceDiagnostics();
        if (diagnosticInfo != null) {
            DiagnosticInfo.toString(diagnosticInfo, stringBuilder, false, true, false);
        }
        if (stringBuilder.length() == 0) {
            return "ServiceFault";
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

