/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.BuildInfo;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ServerState;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ServerStatusDataType
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ServerStatusDataType);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ServerStatusDataType_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ServerStatusDataType_Encoding_DefaultXml);
    protected DateTime StartTime;
    protected DateTime CurrentTime;
    protected ServerState State;
    protected BuildInfo BuildInfo;
    protected UnsignedInteger SecondsTillShutdown;
    protected LocalizedText ShutdownReason;

    public ServerStatusDataType() {
    }

    public ServerStatusDataType(DateTime dateTime, DateTime dateTime2, ServerState serverState, BuildInfo buildInfo, UnsignedInteger unsignedInteger, LocalizedText localizedText) {
        this.StartTime = dateTime;
        this.CurrentTime = dateTime2;
        this.State = serverState;
        this.BuildInfo = buildInfo;
        this.SecondsTillShutdown = unsignedInteger;
        this.ShutdownReason = localizedText;
    }

    public DateTime getStartTime() {
        return this.StartTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.StartTime = dateTime;
    }

    public DateTime getCurrentTime() {
        return this.CurrentTime;
    }

    public void setCurrentTime(DateTime dateTime) {
        this.CurrentTime = dateTime;
    }

    public ServerState getState() {
        return this.State;
    }

    public void setState(ServerState serverState) {
        this.State = serverState;
    }

    public BuildInfo getBuildInfo() {
        return this.BuildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.BuildInfo = buildInfo;
    }

    public UnsignedInteger getSecondsTillShutdown() {
        return this.SecondsTillShutdown;
    }

    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) {
        this.SecondsTillShutdown = unsignedInteger;
    }

    public LocalizedText getShutdownReason() {
        return this.ShutdownReason;
    }

    public void setShutdownReason(LocalizedText localizedText) {
        this.ShutdownReason = localizedText;
    }

    public ServerStatusDataType clone() {
        ServerStatusDataType serverStatusDataType = new ServerStatusDataType();
        serverStatusDataType.StartTime = this.StartTime;
        serverStatusDataType.CurrentTime = this.CurrentTime;
        serverStatusDataType.State = this.State;
        serverStatusDataType.BuildInfo = this.BuildInfo == null ? null : this.BuildInfo.clone();
        serverStatusDataType.SecondsTillShutdown = this.SecondsTillShutdown;
        serverStatusDataType.ShutdownReason = this.ShutdownReason;
        return serverStatusDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerStatusDataType serverStatusDataType = (ServerStatusDataType)object;
        if (this.StartTime == null ? serverStatusDataType.StartTime != null : !this.StartTime.equals(serverStatusDataType.StartTime)) {
            return false;
        }
        if (this.CurrentTime == null ? serverStatusDataType.CurrentTime != null : !this.CurrentTime.equals(serverStatusDataType.CurrentTime)) {
            return false;
        }
        if (this.State == null ? serverStatusDataType.State != null : !this.State.equals(serverStatusDataType.State)) {
            return false;
        }
        if (this.BuildInfo == null ? serverStatusDataType.BuildInfo != null : !this.BuildInfo.equals(serverStatusDataType.BuildInfo)) {
            return false;
        }
        if (this.SecondsTillShutdown == null ? serverStatusDataType.SecondsTillShutdown != null : !this.SecondsTillShutdown.equals(serverStatusDataType.SecondsTillShutdown)) {
            return false;
        }
        return !(this.ShutdownReason == null ? serverStatusDataType.ShutdownReason != null : !this.ShutdownReason.equals(serverStatusDataType.ShutdownReason));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.StartTime == null ? 0 : this.StartTime.hashCode());
        n = 31 * n + (this.CurrentTime == null ? 0 : this.CurrentTime.hashCode());
        n = 31 * n + (this.State == null ? 0 : this.State.hashCode());
        n = 31 * n + (this.BuildInfo == null ? 0 : this.BuildInfo.hashCode());
        n = 31 * n + (this.SecondsTillShutdown == null ? 0 : this.SecondsTillShutdown.hashCode());
        n = 31 * n + (this.ShutdownReason == null ? 0 : this.ShutdownReason.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "ServerStatusDataType: " + ObjectUtils.printFieldsDeep(this);
    }
}

