/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ResponseHeader
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ResponseHeader);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ResponseHeader_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ResponseHeader_Encoding_DefaultXml);
    protected DateTime Timestamp;
    protected UnsignedInteger RequestHandle;
    protected StatusCode ServiceResult;
    protected DiagnosticInfo ServiceDiagnostics;
    protected String[] StringTable;
    protected ExtensionObject AdditionalHeader;

    public ResponseHeader() {
    }

    public ResponseHeader(DateTime dateTime, UnsignedInteger unsignedInteger, StatusCode statusCode, DiagnosticInfo diagnosticInfo, String[] stringArray, ExtensionObject extensionObject) {
        this.Timestamp = dateTime;
        this.RequestHandle = unsignedInteger;
        this.ServiceResult = statusCode;
        this.ServiceDiagnostics = diagnosticInfo;
        this.StringTable = stringArray;
        this.AdditionalHeader = extensionObject;
    }

    public DateTime getTimestamp() {
        return this.Timestamp;
    }

    public void setTimestamp(DateTime dateTime) {
        this.Timestamp = dateTime;
    }

    public UnsignedInteger getRequestHandle() {
        return this.RequestHandle;
    }

    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        this.RequestHandle = unsignedInteger;
    }

    public StatusCode getServiceResult() {
        return this.ServiceResult;
    }

    public void setServiceResult(StatusCode statusCode) {
        this.ServiceResult = statusCode;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.ServiceDiagnostics;
    }

    public void setServiceDiagnostics(DiagnosticInfo diagnosticInfo) {
        this.ServiceDiagnostics = diagnosticInfo;
    }

    public String[] getStringTable() {
        return this.StringTable;
    }

    public void setStringTable(String[] stringArray) {
        this.StringTable = stringArray;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.AdditionalHeader;
    }

    public void setAdditionalHeader(ExtensionObject extensionObject) {
        this.AdditionalHeader = extensionObject;
    }

    public ResponseHeader clone() {
        ResponseHeader responseHeader = new ResponseHeader();
        responseHeader.Timestamp = this.Timestamp;
        responseHeader.RequestHandle = this.RequestHandle;
        responseHeader.ServiceResult = this.ServiceResult;
        responseHeader.ServiceDiagnostics = this.ServiceDiagnostics;
        responseHeader.StringTable = this.StringTable == null ? null : (String[])this.StringTable.clone();
        responseHeader.AdditionalHeader = this.AdditionalHeader;
        return responseHeader;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResponseHeader responseHeader = (ResponseHeader)object;
        if (this.Timestamp == null ? responseHeader.Timestamp != null : !this.Timestamp.equals(responseHeader.Timestamp)) {
            return false;
        }
        if (this.RequestHandle == null ? responseHeader.RequestHandle != null : !this.RequestHandle.equals(responseHeader.RequestHandle)) {
            return false;
        }
        if (this.ServiceResult == null ? responseHeader.ServiceResult != null : !this.ServiceResult.equals(responseHeader.ServiceResult)) {
            return false;
        }
        if (this.ServiceDiagnostics == null ? responseHeader.ServiceDiagnostics != null : !this.ServiceDiagnostics.equals(responseHeader.ServiceDiagnostics)) {
            return false;
        }
        if (this.StringTable == null ? responseHeader.StringTable != null : !Arrays.equals(this.StringTable, responseHeader.StringTable)) {
            return false;
        }
        return !(this.AdditionalHeader == null ? responseHeader.AdditionalHeader != null : !this.AdditionalHeader.equals(responseHeader.AdditionalHeader));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.Timestamp == null ? 0 : this.Timestamp.hashCode());
        n = 31 * n + (this.RequestHandle == null ? 0 : this.RequestHandle.hashCode());
        n = 31 * n + (this.ServiceResult == null ? 0 : this.ServiceResult.hashCode());
        n = 31 * n + (this.ServiceDiagnostics == null ? 0 : this.ServiceDiagnostics.hashCode());
        n = 31 * n + (this.StringTable == null ? 0 : Arrays.hashCode(this.StringTable));
        n = 31 * n + (this.AdditionalHeader == null ? 0 : this.AdditionalHeader.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "ResponseHeader: " + ObjectUtils.printFieldsDeep(this);
    }
}

