/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ReadRequest
implements ServiceRequest {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ReadRequest);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ReadRequest_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ReadRequest_Encoding_DefaultXml);
    protected RequestHeader RequestHeader;
    protected Double MaxAge;
    protected TimestampsToReturn TimestampsToReturn;
    protected ReadValueId[] NodesToRead;

    public ReadRequest() {
    }

    public ReadRequest(RequestHeader requestHeader, Double d, TimestampsToReturn timestampsToReturn, ReadValueId[] readValueIdArray) {
        this.RequestHeader = requestHeader;
        this.MaxAge = d;
        this.TimestampsToReturn = timestampsToReturn;
        this.NodesToRead = readValueIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.RequestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.RequestHeader = requestHeader;
    }

    public Double getMaxAge() {
        return this.MaxAge;
    }

    public void setMaxAge(Double d) {
        this.MaxAge = d;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.TimestampsToReturn;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.TimestampsToReturn = timestampsToReturn;
    }

    public ReadValueId[] getNodesToRead() {
        return this.NodesToRead;
    }

    public void setNodesToRead(ReadValueId[] readValueIdArray) {
        this.NodesToRead = readValueIdArray;
    }

    public ReadRequest clone() {
        ReadRequest readRequest = new ReadRequest();
        readRequest.RequestHeader = this.RequestHeader == null ? null : this.RequestHeader.clone();
        readRequest.MaxAge = this.MaxAge;
        readRequest.TimestampsToReturn = this.TimestampsToReturn;
        if (this.NodesToRead != null) {
            readRequest.NodesToRead = new ReadValueId[this.NodesToRead.length];
            for (int i = 0; i < this.NodesToRead.length; ++i) {
                readRequest.NodesToRead[i] = this.NodesToRead[i].clone();
            }
        }
        return readRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadRequest readRequest = (ReadRequest)object;
        if (this.RequestHeader == null ? readRequest.RequestHeader != null : !this.RequestHeader.equals(readRequest.RequestHeader)) {
            return false;
        }
        if (this.MaxAge == null ? readRequest.MaxAge != null : !this.MaxAge.equals(readRequest.MaxAge)) {
            return false;
        }
        if (this.TimestampsToReturn == null ? readRequest.TimestampsToReturn != null : !this.TimestampsToReturn.equals(readRequest.TimestampsToReturn)) {
            return false;
        }
        return !(this.NodesToRead == null ? readRequest.NodesToRead != null : !Arrays.equals(this.NodesToRead, readRequest.NodesToRead));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.RequestHeader == null ? 0 : this.RequestHeader.hashCode());
        n = 31 * n + (this.MaxAge == null ? 0 : this.MaxAge.hashCode());
        n = 31 * n + (this.TimestampsToReturn == null ? 0 : this.TimestampsToReturn.hashCode());
        n = 31 * n + (this.NodesToRead == null ? 0 : Arrays.hashCode(this.NodesToRead));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

