/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.InstanceNode;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ObjectNode
extends InstanceNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ObjectNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ObjectNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ObjectNode_Encoding_DefaultXml);
    protected UnsignedByte EventNotifier;

    public ObjectNode() {
    }

    public ObjectNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, UnsignedByte unsignedByte) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.EventNotifier = unsignedByte;
    }

    public UnsignedByte getEventNotifier() {
        return this.EventNotifier;
    }

    public void setEventNotifier(UnsignedByte unsignedByte) {
        this.EventNotifier = unsignedByte;
    }

    @Override
    public ObjectNode clone() {
        ObjectNode objectNode = new ObjectNode();
        objectNode.NodeId = this.NodeId;
        objectNode.NodeClass = this.NodeClass;
        objectNode.BrowseName = this.BrowseName;
        objectNode.DisplayName = this.DisplayName;
        objectNode.Description = this.Description;
        objectNode.WriteMask = this.WriteMask;
        objectNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            objectNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                objectNode.References[i] = this.References[i].clone();
            }
        }
        objectNode.EventNotifier = this.EventNotifier;
        return objectNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)object;
        if (this.NodeId == null ? objectNode.NodeId != null : !this.NodeId.equals(objectNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? objectNode.NodeClass != null : !this.NodeClass.equals(objectNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? objectNode.BrowseName != null : !this.BrowseName.equals(objectNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? objectNode.DisplayName != null : !this.DisplayName.equals(objectNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? objectNode.Description != null : !this.Description.equals(objectNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? objectNode.WriteMask != null : !this.WriteMask.equals(objectNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? objectNode.UserWriteMask != null : !this.UserWriteMask.equals(objectNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? objectNode.References != null : !Arrays.equals(this.References, objectNode.References)) {
            return false;
        }
        return !(this.EventNotifier == null ? objectNode.EventNotifier != null : !this.EventNotifier.equals(objectNode.EventNotifier));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.EventNotifier == null ? 0 : this.EventNotifier.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "ObjectNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

