/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class NotificationMessage
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.NotificationMessage);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.NotificationMessage_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.NotificationMessage_Encoding_DefaultXml);
    protected UnsignedInteger SequenceNumber;
    protected DateTime PublishTime;
    protected ExtensionObject[] NotificationData;

    public NotificationMessage() {
    }

    public NotificationMessage(UnsignedInteger unsignedInteger, DateTime dateTime, ExtensionObject[] extensionObjectArray) {
        this.SequenceNumber = unsignedInteger;
        this.PublishTime = dateTime;
        this.NotificationData = extensionObjectArray;
    }

    public UnsignedInteger getSequenceNumber() {
        return this.SequenceNumber;
    }

    public void setSequenceNumber(UnsignedInteger unsignedInteger) {
        this.SequenceNumber = unsignedInteger;
    }

    public DateTime getPublishTime() {
        return this.PublishTime;
    }

    public void setPublishTime(DateTime dateTime) {
        this.PublishTime = dateTime;
    }

    public ExtensionObject[] getNotificationData() {
        return this.NotificationData;
    }

    public void setNotificationData(ExtensionObject[] extensionObjectArray) {
        this.NotificationData = extensionObjectArray;
    }

    public NotificationMessage clone() {
        NotificationMessage notificationMessage = new NotificationMessage();
        notificationMessage.SequenceNumber = this.SequenceNumber;
        notificationMessage.PublishTime = this.PublishTime;
        notificationMessage.NotificationData = this.NotificationData == null ? null : (ExtensionObject[])this.NotificationData.clone();
        return notificationMessage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NotificationMessage notificationMessage = (NotificationMessage)object;
        if (this.SequenceNumber == null ? notificationMessage.SequenceNumber != null : !this.SequenceNumber.equals(notificationMessage.SequenceNumber)) {
            return false;
        }
        if (this.PublishTime == null ? notificationMessage.PublishTime != null : !this.PublishTime.equals(notificationMessage.PublishTime)) {
            return false;
        }
        return !(this.NotificationData == null ? notificationMessage.NotificationData != null : !Arrays.equals(this.NotificationData, notificationMessage.NotificationData));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.SequenceNumber == null ? 0 : this.SequenceNumber.hashCode());
        n = 31 * n + (this.PublishTime == null ? 0 : this.PublishTime.hashCode());
        n = 31 * n + (this.NotificationData == null ? 0 : Arrays.hashCode(this.NotificationData));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "NotificationMessage: " + ObjectUtils.printFieldsDeep(this);
    }
}

