/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class Node
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.Node);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.Node_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.Node_Encoding_DefaultXml);
    protected NodeId NodeId;
    protected NodeClass NodeClass;
    protected QualifiedName BrowseName;
    protected LocalizedText DisplayName;
    protected LocalizedText Description;
    protected UnsignedInteger WriteMask;
    protected UnsignedInteger UserWriteMask;
    protected ReferenceNode[] References;

    public Node() {
    }

    public Node(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray) {
        this.NodeId = nodeId;
        this.NodeClass = nodeClass;
        this.BrowseName = qualifiedName;
        this.DisplayName = localizedText;
        this.Description = localizedText2;
        this.WriteMask = unsignedInteger;
        this.UserWriteMask = unsignedInteger2;
        this.References = referenceNodeArray;
    }

    public NodeId getNodeId() {
        return this.NodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.NodeId = nodeId;
    }

    public NodeClass getNodeClass() {
        return this.NodeClass;
    }

    public void setNodeClass(NodeClass nodeClass) {
        this.NodeClass = nodeClass;
    }

    public QualifiedName getBrowseName() {
        return this.BrowseName;
    }

    public void setBrowseName(QualifiedName qualifiedName) {
        this.BrowseName = qualifiedName;
    }

    public LocalizedText getDisplayName() {
        return this.DisplayName;
    }

    public void setDisplayName(LocalizedText localizedText) {
        this.DisplayName = localizedText;
    }

    public LocalizedText getDescription() {
        return this.Description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.Description = localizedText;
    }

    public UnsignedInteger getWriteMask() {
        return this.WriteMask;
    }

    public void setWriteMask(UnsignedInteger unsignedInteger) {
        this.WriteMask = unsignedInteger;
    }

    public UnsignedInteger getUserWriteMask() {
        return this.UserWriteMask;
    }

    public void setUserWriteMask(UnsignedInteger unsignedInteger) {
        this.UserWriteMask = unsignedInteger;
    }

    public ReferenceNode[] getReferences() {
        return this.References;
    }

    public void setReferences(ReferenceNode[] referenceNodeArray) {
        this.References = referenceNodeArray;
    }

    public Node clone() {
        Node node = new Node();
        node.NodeId = this.NodeId;
        node.NodeClass = this.NodeClass;
        node.BrowseName = this.BrowseName;
        node.DisplayName = this.DisplayName;
        node.Description = this.Description;
        node.WriteMask = this.WriteMask;
        node.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            node.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                node.References[i] = this.References[i].clone();
            }
        }
        return node;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Node node = (Node)object;
        if (this.NodeId == null ? node.NodeId != null : !this.NodeId.equals(node.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? node.NodeClass != null : !this.NodeClass.equals(node.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? node.BrowseName != null : !this.BrowseName.equals(node.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? node.DisplayName != null : !this.DisplayName.equals(node.DisplayName)) {
            return false;
        }
        if (this.Description == null ? node.Description != null : !this.Description.equals(node.Description)) {
            return false;
        }
        if (this.WriteMask == null ? node.WriteMask != null : !this.WriteMask.equals(node.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? node.UserWriteMask != null : !this.UserWriteMask.equals(node.UserWriteMask)) {
            return false;
        }
        return !(this.References == null ? node.References != null : !Arrays.equals(this.References, node.References));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "Node: " + ObjectUtils.printFieldsDeep(this);
    }
}

