/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.EnumSet;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum MessageSecurityMode implements Enumeration
{
    Invalid,
    None,
    Sign,
    SignAndEncrypt;

    public static final NodeId ID;
    public static EnumSet<MessageSecurityMode> NONE;
    public static EnumSet<MessageSecurityMode> ALL;

    @Override
    public int getValue() {
        return this.ordinal();
    }

    public static MessageSecurityMode valueOf(int n) {
        if (n < 0 || n >= MessageSecurityMode.values().length) {
            return null;
        }
        return MessageSecurityMode.values()[n];
    }

    public static MessageSecurityMode valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : MessageSecurityMode.valueOf(unsignedInteger.intValue());
    }

    public static MessageSecurityMode[] valueOf(int[] nArray) {
        MessageSecurityMode[] messageSecurityModeArray = new MessageSecurityMode[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            messageSecurityModeArray[i] = MessageSecurityMode.valueOf(nArray[i]);
        }
        return messageSecurityModeArray;
    }

    public static MessageSecurityMode[] valueOf(Integer[] integerArray) {
        MessageSecurityMode[] messageSecurityModeArray = new MessageSecurityMode[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            messageSecurityModeArray[i] = MessageSecurityMode.valueOf(integerArray[i]);
        }
        return messageSecurityModeArray;
    }

    public static MessageSecurityMode[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        MessageSecurityMode[] messageSecurityModeArray = new MessageSecurityMode[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            messageSecurityModeArray[i] = MessageSecurityMode.valueOf(unsignedIntegerArray[i]);
        }
        return messageSecurityModeArray;
    }

    public boolean hasSigning() {
        return this == Sign || this == SignAndEncrypt;
    }

    public boolean hasEncryption() {
        return this == SignAndEncrypt;
    }

    static {
        ID = Identifiers.MessageSecurityMode;
        NONE = EnumSet.noneOf(MessageSecurityMode.class);
        ALL = EnumSet.allOf(MessageSecurityMode.class);
    }
}

