/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum HistoryUpdateType implements Enumeration
{
    Insert(1),
    Replace(2),
    Update(3),
    Delete(4);

    public static final NodeId ID;
    public static EnumSet<HistoryUpdateType> NONE;
    public static EnumSet<HistoryUpdateType> ALL;
    private final int value;
    private static final Map<Integer, HistoryUpdateType> map;

    private HistoryUpdateType(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static HistoryUpdateType valueOf(int n) {
        return map.get(n);
    }

    public static HistoryUpdateType valueOf(Integer n) {
        return n == null ? null : HistoryUpdateType.valueOf((int)n);
    }

    public static HistoryUpdateType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : HistoryUpdateType.valueOf(unsignedInteger.intValue());
    }

    public static HistoryUpdateType[] valueOf(int[] nArray) {
        HistoryUpdateType[] historyUpdateTypeArray = new HistoryUpdateType[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            historyUpdateTypeArray[i] = HistoryUpdateType.valueOf(nArray[i]);
        }
        return historyUpdateTypeArray;
    }

    public static HistoryUpdateType[] valueOf(Integer[] integerArray) {
        HistoryUpdateType[] historyUpdateTypeArray = new HistoryUpdateType[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            historyUpdateTypeArray[i] = HistoryUpdateType.valueOf(integerArray[i]);
        }
        return historyUpdateTypeArray;
    }

    public static HistoryUpdateType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        HistoryUpdateType[] historyUpdateTypeArray = new HistoryUpdateType[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            historyUpdateTypeArray[i] = HistoryUpdateType.valueOf(unsignedIntegerArray[i]);
        }
        return historyUpdateTypeArray;
    }

    public static UnsignedInteger getMask(HistoryUpdateType ... historyUpdateTypeArray) {
        int n = 0;
        for (HistoryUpdateType historyUpdateType : historyUpdateTypeArray) {
            n |= historyUpdateType.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<HistoryUpdateType> collection) {
        int n = 0;
        for (HistoryUpdateType historyUpdateType : collection) {
            n |= historyUpdateType.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<HistoryUpdateType> getSet(UnsignedInteger unsignedInteger) {
        return HistoryUpdateType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<HistoryUpdateType> getSet(int n) {
        ArrayList<HistoryUpdateType> arrayList = new ArrayList<HistoryUpdateType>();
        for (HistoryUpdateType historyUpdateType : HistoryUpdateType.values()) {
            if ((n & historyUpdateType.value) != historyUpdateType.value) continue;
            arrayList.add(historyUpdateType);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.HistoryUpdateType;
        NONE = EnumSet.noneOf(HistoryUpdateType.class);
        ALL = EnumSet.allOf(HistoryUpdateType.class);
        map = new HashMap<Integer, HistoryUpdateType>();
        for (HistoryUpdateType historyUpdateType : HistoryUpdateType.values()) {
            map.put(historyUpdateType.value, historyUpdateType);
        }
    }
}

