/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.core.HistoryUpdateResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.utils.ObjectUtils;

public class HistoryUpdateResponse
implements ServiceResponse {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.HistoryUpdateResponse);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.HistoryUpdateResponse_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.HistoryUpdateResponse_Encoding_DefaultXml);
    protected ResponseHeader ResponseHeader;
    protected HistoryUpdateResult[] Results;
    protected DiagnosticInfo[] DiagnosticInfos;

    public HistoryUpdateResponse() {
    }

    public HistoryUpdateResponse(ResponseHeader responseHeader, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ResponseHeader = responseHeader;
        this.Results = historyUpdateResultArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.ResponseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.ResponseHeader = responseHeader;
    }

    public HistoryUpdateResult[] getResults() {
        return this.Results;
    }

    public void setResults(HistoryUpdateResult[] historyUpdateResultArray) {
        this.Results = historyUpdateResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public HistoryUpdateResponse clone() {
        HistoryUpdateResponse historyUpdateResponse = new HistoryUpdateResponse();
        ResponseHeader responseHeader = historyUpdateResponse.ResponseHeader = this.ResponseHeader == null ? null : this.ResponseHeader.clone();
        if (this.Results != null) {
            historyUpdateResponse.Results = new HistoryUpdateResult[this.Results.length];
            for (int i = 0; i < this.Results.length; ++i) {
                historyUpdateResponse.Results[i] = this.Results[i].clone();
            }
        }
        historyUpdateResponse.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return historyUpdateResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryUpdateResponse historyUpdateResponse = (HistoryUpdateResponse)object;
        if (this.ResponseHeader == null ? historyUpdateResponse.ResponseHeader != null : !this.ResponseHeader.equals(historyUpdateResponse.ResponseHeader)) {
            return false;
        }
        if (this.Results == null ? historyUpdateResponse.Results != null : !Arrays.equals(this.Results, historyUpdateResponse.Results)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? historyUpdateResponse.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, historyUpdateResponse.DiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ResponseHeader == null ? 0 : this.ResponseHeader.hashCode());
        n = 31 * n + (this.Results == null ? 0 : Arrays.hashCode(this.Results));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return ObjectUtils.printFieldsDeep(this);
    }
}

