/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.ContentFilter;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.SimpleAttributeOperand;
import org.opcfoundation.ua.utils.ObjectUtils;

public class EventFilter
extends MonitoringFilter
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.EventFilter);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.EventFilter_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.EventFilter_Encoding_DefaultXml);
    protected SimpleAttributeOperand[] SelectClauses;
    protected ContentFilter WhereClause;

    public EventFilter() {
    }

    public EventFilter(SimpleAttributeOperand[] simpleAttributeOperandArray, ContentFilter contentFilter) {
        this.SelectClauses = simpleAttributeOperandArray;
        this.WhereClause = contentFilter;
    }

    public SimpleAttributeOperand[] getSelectClauses() {
        return this.SelectClauses;
    }

    public void setSelectClauses(SimpleAttributeOperand[] simpleAttributeOperandArray) {
        this.SelectClauses = simpleAttributeOperandArray;
    }

    public ContentFilter getWhereClause() {
        return this.WhereClause;
    }

    public void setWhereClause(ContentFilter contentFilter) {
        this.WhereClause = contentFilter;
    }

    @Override
    public EventFilter clone() {
        EventFilter eventFilter = new EventFilter();
        if (this.SelectClauses != null) {
            eventFilter.SelectClauses = new SimpleAttributeOperand[this.SelectClauses.length];
            for (int i = 0; i < this.SelectClauses.length; ++i) {
                eventFilter.SelectClauses[i] = this.SelectClauses[i].clone();
            }
        }
        eventFilter.WhereClause = this.WhereClause == null ? null : this.WhereClause.clone();
        return eventFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFilter eventFilter = (EventFilter)object;
        if (this.SelectClauses == null ? eventFilter.SelectClauses != null : !Arrays.equals(this.SelectClauses, eventFilter.SelectClauses)) {
            return false;
        }
        return !(this.WhereClause == null ? eventFilter.WhereClause != null : !this.WhereClause.equals(eventFilter.WhereClause));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.SelectClauses == null ? 0 : Arrays.hashCode(this.SelectClauses));
        n = 31 * n + (this.WhereClause == null ? 0 : this.WhereClause.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "EventFilter: " + ObjectUtils.printFieldsDeep(this);
    }
}

