/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ReferenceNode;
import org.opcfoundation.ua.core.TypeNode;
import org.opcfoundation.ua.utils.ObjectUtils;

public class DataTypeNode
extends TypeNode
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.DataTypeNode);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.DataTypeNode_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.DataTypeNode_Encoding_DefaultXml);
    protected Boolean IsAbstract;

    public DataTypeNode() {
    }

    public DataTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, ReferenceNode[] referenceNodeArray, Boolean bl) {
        super(nodeId, nodeClass, qualifiedName, localizedText, localizedText2, unsignedInteger, unsignedInteger2, referenceNodeArray);
        this.IsAbstract = bl;
    }

    public Boolean getIsAbstract() {
        return this.IsAbstract;
    }

    public void setIsAbstract(Boolean bl) {
        this.IsAbstract = bl;
    }

    @Override
    public DataTypeNode clone() {
        DataTypeNode dataTypeNode = new DataTypeNode();
        dataTypeNode.NodeId = this.NodeId;
        dataTypeNode.NodeClass = this.NodeClass;
        dataTypeNode.BrowseName = this.BrowseName;
        dataTypeNode.DisplayName = this.DisplayName;
        dataTypeNode.Description = this.Description;
        dataTypeNode.WriteMask = this.WriteMask;
        dataTypeNode.UserWriteMask = this.UserWriteMask;
        if (this.References != null) {
            dataTypeNode.References = new ReferenceNode[this.References.length];
            for (int i = 0; i < this.References.length; ++i) {
                dataTypeNode.References[i] = this.References[i].clone();
            }
        }
        dataTypeNode.IsAbstract = this.IsAbstract;
        return dataTypeNode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)object;
        if (this.NodeId == null ? dataTypeNode.NodeId != null : !this.NodeId.equals(dataTypeNode.NodeId)) {
            return false;
        }
        if (this.NodeClass == null ? dataTypeNode.NodeClass != null : !this.NodeClass.equals(dataTypeNode.NodeClass)) {
            return false;
        }
        if (this.BrowseName == null ? dataTypeNode.BrowseName != null : !this.BrowseName.equals(dataTypeNode.BrowseName)) {
            return false;
        }
        if (this.DisplayName == null ? dataTypeNode.DisplayName != null : !this.DisplayName.equals(dataTypeNode.DisplayName)) {
            return false;
        }
        if (this.Description == null ? dataTypeNode.Description != null : !this.Description.equals(dataTypeNode.Description)) {
            return false;
        }
        if (this.WriteMask == null ? dataTypeNode.WriteMask != null : !this.WriteMask.equals(dataTypeNode.WriteMask)) {
            return false;
        }
        if (this.UserWriteMask == null ? dataTypeNode.UserWriteMask != null : !this.UserWriteMask.equals(dataTypeNode.UserWriteMask)) {
            return false;
        }
        if (this.References == null ? dataTypeNode.References != null : !Arrays.equals(this.References, dataTypeNode.References)) {
            return false;
        }
        return !(this.IsAbstract == null ? dataTypeNode.IsAbstract != null : !this.IsAbstract.equals(dataTypeNode.IsAbstract));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.NodeClass == null ? 0 : this.NodeClass.hashCode());
        n = 31 * n + (this.BrowseName == null ? 0 : this.BrowseName.hashCode());
        n = 31 * n + (this.DisplayName == null ? 0 : this.DisplayName.hashCode());
        n = 31 * n + (this.Description == null ? 0 : this.Description.hashCode());
        n = 31 * n + (this.WriteMask == null ? 0 : this.WriteMask.hashCode());
        n = 31 * n + (this.UserWriteMask == null ? 0 : this.UserWriteMask.hashCode());
        n = 31 * n + (this.References == null ? 0 : Arrays.hashCode(this.References));
        n = 31 * n + (this.IsAbstract == null ? 0 : this.IsAbstract.hashCode());
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "DataTypeNode: " + ObjectUtils.printFieldsDeep(this);
    }
}

