/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoredItemNotification;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.utils.ObjectUtils;

public class DataChangeNotification
extends NotificationData
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.DataChangeNotification);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.DataChangeNotification_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.DataChangeNotification_Encoding_DefaultXml);
    protected MonitoredItemNotification[] MonitoredItems;
    protected DiagnosticInfo[] DiagnosticInfos;

    public DataChangeNotification() {
    }

    public DataChangeNotification(MonitoredItemNotification[] monitoredItemNotificationArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.MonitoredItems = monitoredItemNotificationArray;
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    public MonitoredItemNotification[] getMonitoredItems() {
        return this.MonitoredItems;
    }

    public void setMonitoredItems(MonitoredItemNotification[] monitoredItemNotificationArray) {
        this.MonitoredItems = monitoredItemNotificationArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.DiagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.DiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public DataChangeNotification clone() {
        DataChangeNotification dataChangeNotification = new DataChangeNotification();
        if (this.MonitoredItems != null) {
            dataChangeNotification.MonitoredItems = new MonitoredItemNotification[this.MonitoredItems.length];
            for (int i = 0; i < this.MonitoredItems.length; ++i) {
                dataChangeNotification.MonitoredItems[i] = this.MonitoredItems[i].clone();
            }
        }
        dataChangeNotification.DiagnosticInfos = this.DiagnosticInfos == null ? null : (DiagnosticInfo[])this.DiagnosticInfos.clone();
        return dataChangeNotification;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataChangeNotification dataChangeNotification = (DataChangeNotification)object;
        if (this.MonitoredItems == null ? dataChangeNotification.MonitoredItems != null : !Arrays.equals(this.MonitoredItems, dataChangeNotification.MonitoredItems)) {
            return false;
        }
        return !(this.DiagnosticInfos == null ? dataChangeNotification.DiagnosticInfos != null : !Arrays.equals(this.DiagnosticInfos, dataChangeNotification.DiagnosticInfos));
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.MonitoredItems == null ? 0 : Arrays.hashCode(this.MonitoredItems));
        n = 31 * n + (this.DiagnosticInfos == null ? 0 : Arrays.hashCode(this.DiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    public String toString() {
        return "DataChangeNotification: " + ObjectUtils.printFieldsDeep(this);
    }
}

