/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.core.ContentFilterElementResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class ContentFilterResult
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.ContentFilterResult);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.ContentFilterResult_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.ContentFilterResult_Encoding_DefaultXml);
    protected ContentFilterElementResult[] ElementResults;
    protected DiagnosticInfo[] ElementDiagnosticInfos;

    public ContentFilterResult() {
    }

    public ContentFilterResult(ContentFilterElementResult[] contentFilterElementResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.ElementResults = contentFilterElementResultArray;
        this.ElementDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.ElementResults;
    }

    public void setElementResults(ContentFilterElementResult[] contentFilterElementResultArray) {
        this.ElementResults = contentFilterElementResultArray;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.ElementDiagnosticInfos;
    }

    public void setElementDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.ElementDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterResult clone() {
        ContentFilterResult contentFilterResult = new ContentFilterResult();
        if (this.ElementResults != null) {
            contentFilterResult.ElementResults = new ContentFilterElementResult[this.ElementResults.length];
            for (int i = 0; i < this.ElementResults.length; ++i) {
                contentFilterResult.ElementResults[i] = this.ElementResults[i].clone();
            }
        }
        contentFilterResult.ElementDiagnosticInfos = this.ElementDiagnosticInfos == null ? null : (DiagnosticInfo[])this.ElementDiagnosticInfos.clone();
        return contentFilterResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentFilterResult contentFilterResult = (ContentFilterResult)object;
        if (this.ElementResults == null ? contentFilterResult.ElementResults != null : !Arrays.equals(this.ElementResults, contentFilterResult.ElementResults)) {
            return false;
        }
        return !(this.ElementDiagnosticInfos == null ? contentFilterResult.ElementDiagnosticInfos != null : !Arrays.equals(this.ElementDiagnosticInfos, contentFilterResult.ElementDiagnosticInfos));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.ElementResults == null ? 0 : Arrays.hashCode(this.ElementResults));
        n = 31 * n + (this.ElementDiagnosticInfos == null ? 0 : Arrays.hashCode(this.ElementDiagnosticInfos));
        return n;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "ContentFilterResult: " + ObjectUtils.printFieldsDeep(this);
    }
}

