/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.Enumeration;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Identifiers;

public enum BrowseResultMask implements Enumeration
{
    None(0),
    ReferenceTypeId(1),
    IsForward(2),
    NodeClass(4),
    BrowseName(8),
    DisplayName(16),
    TypeDefinition(32),
    All(63),
    ReferenceTypeInfo(3),
    TargetInfo(60);

    public static final NodeId ID;
    public static EnumSet<BrowseResultMask> NONE;
    public static EnumSet<BrowseResultMask> ALL;
    private final int value;
    private static final Map<Integer, BrowseResultMask> map;

    private BrowseResultMask(int n2) {
        this.value = n2;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static BrowseResultMask valueOf(int n) {
        return map.get(n);
    }

    public static BrowseResultMask valueOf(Integer n) {
        return n == null ? null : BrowseResultMask.valueOf((int)n);
    }

    public static BrowseResultMask valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : BrowseResultMask.valueOf(unsignedInteger.intValue());
    }

    public static BrowseResultMask[] valueOf(int[] nArray) {
        BrowseResultMask[] browseResultMaskArray = new BrowseResultMask[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            browseResultMaskArray[i] = BrowseResultMask.valueOf(nArray[i]);
        }
        return browseResultMaskArray;
    }

    public static BrowseResultMask[] valueOf(Integer[] integerArray) {
        BrowseResultMask[] browseResultMaskArray = new BrowseResultMask[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            browseResultMaskArray[i] = BrowseResultMask.valueOf(integerArray[i]);
        }
        return browseResultMaskArray;
    }

    public static BrowseResultMask[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        BrowseResultMask[] browseResultMaskArray = new BrowseResultMask[unsignedIntegerArray.length];
        for (int i = 0; i < unsignedIntegerArray.length; ++i) {
            browseResultMaskArray[i] = BrowseResultMask.valueOf(unsignedIntegerArray[i]);
        }
        return browseResultMaskArray;
    }

    public static UnsignedInteger getMask(BrowseResultMask ... browseResultMaskArray) {
        int n = 0;
        for (BrowseResultMask browseResultMask : browseResultMaskArray) {
            n |= browseResultMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static UnsignedInteger getMask(Collection<BrowseResultMask> collection) {
        int n = 0;
        for (BrowseResultMask browseResultMask : collection) {
            n |= browseResultMask.value;
        }
        return UnsignedInteger.getFromBits(n);
    }

    public static EnumSet<BrowseResultMask> getSet(UnsignedInteger unsignedInteger) {
        return BrowseResultMask.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<BrowseResultMask> getSet(int n) {
        ArrayList<BrowseResultMask> arrayList = new ArrayList<BrowseResultMask>();
        for (BrowseResultMask browseResultMask : BrowseResultMask.values()) {
            if ((n & browseResultMask.value) != browseResultMask.value) continue;
            arrayList.add(browseResultMask);
        }
        return EnumSet.copyOf(arrayList);
    }

    static {
        ID = Identifiers.BrowseResultMask;
        NONE = EnumSet.noneOf(BrowseResultMask.class);
        ALL = EnumSet.allOf(BrowseResultMask.class);
        map = new HashMap<Integer, BrowseResultMask>();
        for (BrowseResultMask browseResultMask : BrowseResultMask.values()) {
            map.put(browseResultMask.value, browseResultMask);
        }
    }
}

