/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.core;

import java.util.EnumSet;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.utils.ObjectUtils;

public class BrowseDescription
implements Structure,
Cloneable {
    public static final ExpandedNodeId ID = new ExpandedNodeId(Identifiers.BrowseDescription);
    public static final ExpandedNodeId BINARY = new ExpandedNodeId(Identifiers.BrowseDescription_Encoding_DefaultBinary);
    public static final ExpandedNodeId XML = new ExpandedNodeId(Identifiers.BrowseDescription_Encoding_DefaultXml);
    protected NodeId NodeId;
    protected BrowseDirection BrowseDirection;
    protected NodeId ReferenceTypeId;
    protected Boolean IncludeSubtypes;
    protected UnsignedInteger NodeClassMask;
    protected UnsignedInteger ResultMask;

    public BrowseDescription() {
    }

    public BrowseDescription(NodeId nodeId, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        this.NodeId = nodeId;
        this.BrowseDirection = browseDirection;
        this.ReferenceTypeId = nodeId2;
        this.IncludeSubtypes = bl;
        this.NodeClassMask = unsignedInteger;
        this.ResultMask = unsignedInteger2;
    }

    public NodeId getNodeId() {
        return this.NodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.NodeId = nodeId;
    }

    public BrowseDirection getBrowseDirection() {
        return this.BrowseDirection;
    }

    public void setBrowseDirection(BrowseDirection browseDirection) {
        this.BrowseDirection = browseDirection;
    }

    public NodeId getReferenceTypeId() {
        return this.ReferenceTypeId;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.ReferenceTypeId = nodeId;
    }

    public Boolean getIncludeSubtypes() {
        return this.IncludeSubtypes;
    }

    public void setIncludeSubtypes(Boolean bl) {
        this.IncludeSubtypes = bl;
    }

    public UnsignedInteger getNodeClassMask() {
        return this.NodeClassMask;
    }

    public void setNodeClassMask(UnsignedInteger unsignedInteger) {
        this.NodeClassMask = unsignedInteger;
    }

    public UnsignedInteger getResultMask() {
        return this.ResultMask;
    }

    public void setResultMask(UnsignedInteger unsignedInteger) {
        this.ResultMask = unsignedInteger;
    }

    public BrowseDescription clone() {
        BrowseDescription browseDescription = new BrowseDescription();
        browseDescription.NodeId = this.NodeId;
        browseDescription.BrowseDirection = this.BrowseDirection;
        browseDescription.ReferenceTypeId = this.ReferenceTypeId;
        browseDescription.IncludeSubtypes = this.IncludeSubtypes;
        browseDescription.NodeClassMask = this.NodeClassMask;
        browseDescription.ResultMask = this.ResultMask;
        return browseDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseDescription browseDescription = (BrowseDescription)object;
        if (this.NodeId == null ? browseDescription.NodeId != null : !this.NodeId.equals(browseDescription.NodeId)) {
            return false;
        }
        if (this.BrowseDirection == null ? browseDescription.BrowseDirection != null : !this.BrowseDirection.equals(browseDescription.BrowseDirection)) {
            return false;
        }
        if (this.ReferenceTypeId == null ? browseDescription.ReferenceTypeId != null : !this.ReferenceTypeId.equals(browseDescription.ReferenceTypeId)) {
            return false;
        }
        if (this.IncludeSubtypes == null ? browseDescription.IncludeSubtypes != null : !this.IncludeSubtypes.equals(browseDescription.IncludeSubtypes)) {
            return false;
        }
        if (this.NodeClassMask == null ? browseDescription.NodeClassMask != null : !this.NodeClassMask.equals(browseDescription.NodeClassMask)) {
            return false;
        }
        return !(this.ResultMask == null ? browseDescription.ResultMask != null : !this.ResultMask.equals(browseDescription.ResultMask));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.NodeId == null ? 0 : this.NodeId.hashCode());
        n = 31 * n + (this.BrowseDirection == null ? 0 : this.BrowseDirection.hashCode());
        n = 31 * n + (this.ReferenceTypeId == null ? 0 : this.ReferenceTypeId.hashCode());
        n = 31 * n + (this.IncludeSubtypes == null ? 0 : this.IncludeSubtypes.hashCode());
        n = 31 * n + (this.NodeClassMask == null ? 0 : this.NodeClassMask.hashCode());
        n = 31 * n + (this.ResultMask == null ? 0 : this.ResultMask.hashCode());
        return n;
    }

    public void setNodeClassMask(EnumSet<NodeClass> enumSet) {
        int n = 0;
        for (NodeClass nodeClass : enumSet) {
            n |= nodeClass.getValue();
        }
        this.NodeClassMask = UnsignedInteger.valueOf(n);
    }

    public void setResultMask(EnumSet<BrowseResultMask> enumSet) {
        int n = 0;
        for (BrowseResultMask browseResultMask : enumSet) {
            n |= browseResultMask.getValue();
        }
        this.ResultMask = UnsignedInteger.valueOf(n);
    }

    public void setNodeClassMask(NodeClass ... nodeClassArray) {
        int n = 0;
        for (NodeClass nodeClass : nodeClassArray) {
            n |= nodeClass.getValue();
        }
        this.NodeClassMask = UnsignedInteger.valueOf(n);
    }

    public void setResultMask(BrowseResultMask ... browseResultMaskArray) {
        int n = 0;
        for (BrowseResultMask browseResultMask : browseResultMaskArray) {
            n |= browseResultMask.getValue();
        }
        this.ResultMask = UnsignedInteger.valueOf(n);
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    public String toString() {
        return "BrowseDescription: " + ObjectUtils.printFieldsDeep(this);
    }
}

