/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.NodeId;

public class IdentifierDescriptions {
    private static Map<String, NodeId> NAME_MAP = null;

    private static synchronized void readDescriptions() {
        if (NAME_MAP != null) {
            return;
        }
        NAME_MAP = new HashMap<String, NodeId>();
        try {
            Class<?> clazz = Class.forName("org.opcfoundation.ua.core.Identifiers");
            for (Field field : clazz.getFields()) {
                if (!field.getType().equals(NodeId.class)) continue;
                field.setAccessible(true);
                NodeId nodeId = (NodeId)field.get(null);
                String string = field.getName();
                NAME_MAP.put(string, nodeId);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static NodeId toNodeId(String string) {
        IdentifierDescriptions.readDescriptions();
        NodeId nodeId = NAME_MAP.get(string);
        if (nodeId == null) {
            throw new IllegalArgumentException("NodeId not found: " + string);
        }
        return nodeId;
    }
}

