/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.common;

import org.opcfoundation.ua.transport.CloseableObject;
import org.opcfoundation.ua.transport.CloseableObjectState;
import org.opcfoundation.ua.transport.ConnectionMonitor;
import org.opcfoundation.ua.transport.ServerConnection;
import org.opcfoundation.ua.transport.ServerSecureChannel;
import org.opcfoundation.ua.utils.IStatefulObject;
import org.opcfoundation.ua.utils.StateListener;
import org.slf4j.Logger;

public class DebugLogger
implements ConnectionMonitor.ConnectListener,
ServerConnection.SecureChannelListener,
StateListener<CloseableObjectState> {
    Logger logger;

    public DebugLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void onConnect(Object object, ServerConnection serverConnection) {
        this.logger.info("{}: {}", object, (Object)serverConnection);
        if (serverConnection instanceof CloseableObject) {
            ((CloseableObject)((Object)serverConnection)).addStateListener(this);
        }
        serverConnection.addSecureChannelListener(this);
    }

    @Override
    public void onSecureChannelAttached(Object object, ServerSecureChannel serverSecureChannel) {
        this.logger.info("{}: {}", object, (Object)serverSecureChannel);
        if (serverSecureChannel instanceof IStatefulObject) {
            IStatefulObject iStatefulObject = (IStatefulObject)((Object)serverSecureChannel);
            iStatefulObject.addStateListener(this);
        }
    }

    @Override
    public void onStateTransition(IStatefulObject<CloseableObjectState, ?> iStatefulObject, CloseableObjectState closeableObjectState, CloseableObjectState closeableObjectState2) {
        this.logger.info("{}: {}", iStatefulObject, iStatefulObject);
        if (iStatefulObject.getError() != null) {
            Object obj = iStatefulObject.getError();
            this.logger.debug("onStateTransition: failed", obj);
        }
    }

    @Override
    public void onSecureChannelDetached(Object object, ServerSecureChannel serverSecureChannel) {
    }

    @Override
    public void onClose(Object object, ServerConnection serverConnection) {
    }
}

