/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.opcfoundation.ua.utils.XMLFactoryCache;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlElement {
    public static final NodeId ID = Identifiers.XmlElement;
    private static final Charset UTF8 = Charset.forName("utf-8");
    public static final String UTF8_BOM = "\ufeff";
    private Node node;
    private String document;
    private byte[] encoded;
    int hash;

    static boolean areNodesEqual(Node node, Node node2) {
        if (node2 == node) {
            return true;
        }
        if (!ObjectUtils.objectEquals(node.getNodeType(), node2.getNodeType())) {
            return false;
        }
        if (!ObjectUtils.objectEquals(node.getNodeName(), node2.getNodeName())) {
            return false;
        }
        if (!ObjectUtils.objectEquals(node.getLocalName(), node2.getLocalName())) {
            return false;
        }
        if (!ObjectUtils.objectEquals(node.getNamespaceURI(), node2.getNamespaceURI())) {
            return false;
        }
        String string = node.getNodeValue();
        String string2 = node2.getNodeValue();
        if (string == null && string2 != null || string != null && string2 == null) {
            return false;
        }
        if (string != null && !string.trim().equals(string2.trim())) {
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        if (nodeList == null && nodeList2 != null || nodeList != null && nodeList2 == null) {
            return false;
        }
        if (nodeList != null) {
            int n = nodeList.getLength();
            if (nodeList2.getLength() != nodeList.getLength()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                Node node3 = nodeList.item(i);
                for (int j = 0; j < n; ++j) {
                    Node node4 = nodeList2.item(j);
                    if (!XmlElement.areNodesEqual(node3, node4)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    static int h(int n, Object object) {
        if (object == null) {
            return n * 13;
        }
        return n * 13 + object.hashCode();
    }

    static int makeHash(Node node) {
        int n = 123;
        n = n * 13 + node.getNodeType();
        n = XmlElement.h(n, node.getNodeName());
        n = XmlElement.h(n, node.getLocalName());
        n = XmlElement.h(n, node.getNamespaceURI());
        n = XmlElement.h(n, node.getNodeValue());
        return n;
    }

    static String nodeToString(Node node) throws TransformerException {
        Transformer transformer;
        block2: {
            transformer = null;
            try {
                transformer = XMLFactoryCache.getTransformerFactory().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "utf-8");
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        StringWriter stringWriter = new StringWriter();
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public XmlElement(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.encoded = (byte[])byArray.clone();
    }

    public XmlElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.node = node;
        this.hash = XmlElement.makeHash(node);
    }

    public XmlElement(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.document = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!object.getClass().equals(XmlElement.class)) {
            return false;
        }
        XmlElement xmlElement = (XmlElement)object;
        return XmlElement.areNodesEqual(this.getNode(), xmlElement.getNode());
    }

    public synchronized byte[] getData() {
        if (this.encoded != null) {
            return this.encoded;
        }
        if (this.document != null) {
            this.encoded = this.getValue().getBytes(UTF8);
            return this.encoded;
        }
        if (this.node != null) {
            Transformer transformer;
            block7: {
                transformer = null;
                try {
                    transformer = XMLFactoryCache.getTransformerFactory().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "utf-8");
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMSource dOMSource = new DOMSource(this.node);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            try {
                transformer.transform(dOMSource, streamResult);
            }
            catch (TransformerException transformerException) {
                throw new RuntimeException(transformerException);
            }
            this.encoded = byteArrayOutputStream.toByteArray();
        }
        return this.encoded;
    }

    public synchronized Node getNode() {
        if (this.node == null) {
            if (this.encoded != null) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, UTF8);
                    char[] cArray = new char[2];
                    inputStreamReader.read(cArray, 0, inputStreamReader.getEncoding().equals("UTF8") ? 1 : 2);
                    if (cArray[0] != UTF8_BOM.charAt(0)) {
                        byteArrayInputStream = new ByteArrayInputStream(this.encoded);
                        inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, UTF8);
                    }
                    DocumentBuilder documentBuilder = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder();
                    this.node = documentBuilder.parse(new InputSource(inputStreamReader));
                    this.hash = XmlElement.makeHash(this.node);
                }
                catch (SAXException sAXException) {
                    throw new RuntimeException(sAXException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new RuntimeException(parserConfigurationException);
                }
            }
            if (this.document != null) {
                try {
                    StringReader stringReader = new StringReader(this.document);
                    char[] cArray = new char[2];
                    stringReader.read(cArray, 0, 1);
                    if (cArray[0] != UTF8_BOM.charAt(0)) {
                        stringReader = new StringReader(this.document);
                    }
                    DocumentBuilder documentBuilder = XMLFactoryCache.getDocumentBuilderFactory().newDocumentBuilder();
                    this.node = documentBuilder.parse(new InputSource(stringReader));
                    this.hash = XmlElement.makeHash(this.node);
                }
                catch (SAXException sAXException) {
                    throw new RuntimeException(sAXException);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new RuntimeException(parserConfigurationException);
                }
            }
        }
        return this.node;
    }

    public synchronized String getValue() {
        if (this.document != null) {
            return this.document;
        }
        if (this.encoded != null) {
            this.document = new String(this.encoded, UTF8);
            return this.document;
        }
        if (this.node != null) {
            try {
                this.document = XmlElement.nodeToString(this.node);
            }
            catch (TransformerException transformerException) {
                throw new RuntimeException(transformerException);
            }
        }
        return this.document;
    }

    public int hashCode() {
        if (this.node == null) {
            this.getNode();
        }
        return this.hash;
    }

    public String toString() {
        try {
            return XmlElement.nodeToString(this.getNode());
        }
        catch (Exception exception) {
            return this.getValue();
        }
    }
}

