/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;

public final class UnsignedShort
extends Number
implements Comparable<UnsignedShort> {
    private static final long serialVersionUID = 921127710458932841L;
    private static final UnsignedShort[] CACHE = new UnsignedShort[1024];
    public static final NodeId ID = Identifiers.UInt16;
    public static final long L_MAX_VALUE = 65535L;
    public static final long L_MIN_VALUE = 0L;
    public static final UnsignedShort MAX_VALUE = new UnsignedShort(65535L);
    public static final UnsignedShort MIN_VALUE;
    public static final UnsignedShort ZERO;
    public static final UnsignedShort ONE;
    private int value;

    public static UnsignedShort max(UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        return unsignedShort.intValue() < unsignedShort2.intValue() ? unsignedShort2 : unsignedShort;
    }

    public static UnsignedShort min(UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        return unsignedShort.intValue() < unsignedShort2.intValue() ? unsignedShort : unsignedShort2;
    }

    public static UnsignedShort getFromBits(short s) {
        if (s >= 0 && s < CACHE.length) {
            return CACHE[s];
        }
        UnsignedShort unsignedShort = new UnsignedShort(0);
        unsignedShort.value = s & 0xFFFF;
        return unsignedShort;
    }

    public static UnsignedShort valueOf(int n) {
        if (n >= 0 && n < CACHE.length) {
            return CACHE[n];
        }
        return new UnsignedShort(n);
    }

    public UnsignedShort() {
        this.value = 0;
    }

    public UnsignedShort(short s) {
        if (s < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = s;
    }

    public UnsignedShort(int n) throws IllegalArgumentException {
        if (n < 0 || n >= 65536) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = n;
    }

    public UnsignedShort(String string) throws IllegalArgumentException {
        int n = Integer.parseInt(string);
        if (n < 0 || n >= 65536) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = n;
    }

    public UnsignedShort(Number number) {
        long l = number.longValue();
        if (l < 0L || l >= 65536L) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = number.intValue();
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public int compareTo(UnsignedShort unsignedShort) {
        return this.value - unsignedShort.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public short toShortBits() {
        return (short)(this.value & 0xFFFF);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedShort.class)) {
            return false;
        }
        UnsignedShort unsignedShort = (UnsignedShort)object;
        return unsignedShort.value == this.value;
    }

    public UnsignedShort inc() {
        return UnsignedShort.valueOf(this.getValue() + 1);
    }

    public UnsignedShort dec() {
        return UnsignedShort.valueOf(this.getValue() - 1);
    }

    public UnsignedShort add(int n) {
        return UnsignedShort.valueOf(this.getValue() + n);
    }

    public UnsignedShort add(UnsignedShort unsignedShort) {
        return UnsignedShort.valueOf(this.getValue() + unsignedShort.getValue());
    }

    public UnsignedShort subtract(int n) {
        return UnsignedShort.valueOf(this.getValue() - n);
    }

    public UnsignedShort subtract(UnsignedShort unsignedShort) {
        return UnsignedShort.valueOf(this.getValue() - unsignedShort.getValue());
    }

    public static UnsignedShort parseUnsignedShort(String string) throws NumberFormatException, IllegalArgumentException {
        return UnsignedShort.valueOf(Integer.parseInt(string));
    }

    static {
        ZERO = MIN_VALUE = new UnsignedShort(0L);
        ONE = new UnsignedShort(1);
        UnsignedShort.CACHE[0] = ZERO;
        UnsignedShort.CACHE[1] = ONE;
        for (int i = 2; i < CACHE.length; ++i) {
            UnsignedShort.CACHE[i] = new UnsignedShort(i);
        }
    }
}

