/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;

public final class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    public static final NodeId ID = Identifiers.Byte;
    private static final long serialVersionUID = 4691302796477290208L;
    private final int value;
    private static final UnsignedByte[] CACHE = new UnsignedByte[256];
    public static final long L_MAX_VALUE = 255L;
    public static final long L_MIN_VALUE = 0L;
    public static final UnsignedByte MAX_VALUE;
    public static final UnsignedByte MIN_VALUE;
    public static final UnsignedByte ZERO;
    public static final UnsignedByte ONE;

    public static UnsignedByte max(UnsignedByte unsignedByte, UnsignedByte unsignedByte2) {
        return unsignedByte.intValue() < unsignedByte2.intValue() ? unsignedByte2 : unsignedByte;
    }

    public static UnsignedByte min(UnsignedByte unsignedByte, UnsignedByte unsignedByte2) {
        return unsignedByte.intValue() < unsignedByte2.intValue() ? unsignedByte : unsignedByte2;
    }

    public static UnsignedByte valueOf(int n) {
        UnsignedByte.assertValueInRange(n);
        return CACHE[n];
    }

    public static UnsignedByte getFromBits(byte by) {
        return CACHE[by & 0xFF];
    }

    public UnsignedByte() {
        this.value = 0;
    }

    public UnsignedByte(int n) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(n);
        this.value = n;
    }

    public UnsignedByte(long l) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(l);
        this.value = (int)l;
    }

    public UnsignedByte(byte by) throws IllegalArgumentException {
        UnsignedByte.assertValueInRange(by);
        this.value = by;
    }

    public UnsignedByte(String string) throws IllegalArgumentException {
        short s = Short.parseShort(string);
        if (s < MIN_VALUE.getValue() || s > MAX_VALUE.getValue()) {
            throw new IllegalArgumentException("Value out of bounds!");
        }
        this.value = s;
        UnsignedByte.assertValueInRange(this.value);
    }

    public static void assertValueInRange(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Data value underflow!");
        }
        if (n > 255) {
            throw new IllegalArgumentException("Data value overflow!");
        }
    }

    public static void assertValueInRange(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Data value underflow!");
        }
        if (l > 255L) {
            throw new IllegalArgumentException("Data value overflow!");
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    public byte toByteBits() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public int compareTo(UnsignedByte unsignedByte) {
        return this.value - unsignedByte.getValue();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedByte.class)) {
            return false;
        }
        UnsignedByte unsignedByte = (UnsignedByte)object;
        return this.value == unsignedByte.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static UnsignedByte parseUnsignedByte(String string) {
        return UnsignedByte.valueOf(Integer.parseInt(string));
    }

    public UnsignedByte inc() {
        return UnsignedByte.valueOf(this.getValue() + 1);
    }

    public UnsignedByte dec() {
        return UnsignedByte.valueOf(this.getValue() - 1);
    }

    public UnsignedByte add(int n) {
        return UnsignedByte.valueOf(this.getValue() + n);
    }

    public UnsignedByte add(UnsignedByte unsignedByte) {
        return UnsignedByte.valueOf(this.getValue() + unsignedByte.getValue());
    }

    public UnsignedByte subtract(int n) {
        return UnsignedByte.valueOf(this.getValue() - n);
    }

    public UnsignedByte subtract(UnsignedByte unsignedByte) {
        return UnsignedByte.valueOf(this.getValue() - unsignedByte.getValue());
    }

    static {
        ZERO = new UnsignedByte(0);
        ONE = new UnsignedByte(1);
        UnsignedByte.CACHE[0] = ZERO;
        UnsignedByte.CACHE[1] = ONE;
        for (int i = 2; i < CACHE.length; ++i) {
            UnsignedByte.CACHE[i] = new UnsignedByte(i);
        }
        MIN_VALUE = CACHE[0];
        MAX_VALUE = CACHE[255];
    }
}

