/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public final class LocalizedText {
    public static final Pattern LOCALE_PATTERN = Pattern.compile("^(([a-z]{2})(-([A-Z]{2,3}){1})?)?$");
    public static final Locale NO_LOCALE = new Locale("", "");
    public static final Locale NULL_LOCALE = null;
    public static final NodeId ID = Identifiers.LocalizedText;
    public static final LocalizedText NULL = new LocalizedText(null, NULL_LOCALE);
    public static final LocalizedText EMPTY = new LocalizedText("", NULL_LOCALE);
    public static final LocalizedText EMPTY_EN = LocalizedText.english("");
    private String text;
    private String locale;

    public static Locale toLocale(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = LOCALE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return NO_LOCALE;
        }
        String string2 = matcher.group(2);
        String string3 = matcher.group(4);
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        return new Locale(string2, string3);
    }

    public static String toLocaleId(Locale locale) {
        if (locale == null) {
            return null;
        }
        return locale.getLanguage() + (!locale.getCountry().equals("") ? "-" + locale.getCountry() : "");
    }

    public LocalizedText(String string, String string2) {
        this.text = string;
        this.locale = string2;
    }

    public LocalizedText(String string) {
        this(string, NO_LOCALE);
    }

    public static LocalizedText english(String string) {
        return new LocalizedText(string, "en");
    }

    public LocalizedText(String string, Locale locale) {
        this.text = string;
        this.locale = locale == null ? null : locale.toString();
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.text) + 3 * ObjectUtils.hashCode(this.locale);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return this.locale == null && this.text == null;
        }
        if (!(object instanceof LocalizedText)) {
            return false;
        }
        LocalizedText localizedText = (LocalizedText)object;
        return ObjectUtils.objectEquals(this.text, localizedText.text) && ObjectUtils.objectEquals(this.locale, localizedText.locale);
    }

    public String getLocaleId() {
        return this.locale;
    }

    public Locale getLocale() {
        return LocalizedText.toLocale(this.locale);
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        if (this.getLocaleId() == null) {
            return this.getText();
        }
        return "(" + this.getLocaleId() + ") " + this.getText();
    }
}

