/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.builtintypes;

import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.utils.ObjectUtils;

public class DataValue
implements Cloneable {
    public static final NodeId ID = Identifiers.DataValue;
    Variant value;
    StatusCode statusCode;
    DateTime sourceTimestamp;
    UnsignedShort sourcePicoseconds;
    DateTime serverTimestamp;
    UnsignedShort serverPicoseconds;

    public DataValue() {
        this(StatusCode.GOOD);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort, DateTime dateTime2, UnsignedShort unsignedShort2) {
        this.statusCode = statusCode;
        this.sourceTimestamp = dateTime;
        this.serverTimestamp = dateTime2;
        this.sourcePicoseconds = unsignedShort == null ? UnsignedShort.ZERO : unsignedShort;
        this.serverPicoseconds = unsignedShort2 == null ? UnsignedShort.ZERO : unsignedShort2;
        this.setValue(variant);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, DateTime dateTime2) {
        this(variant, statusCode, dateTime, null, dateTime2, null);
    }

    public DataValue(StatusCode statusCode) {
        this(Variant.NULL, statusCode);
    }

    public DataValue(Variant variant, StatusCode statusCode) {
        this(variant, statusCode, null, null, null, null);
    }

    public DataValue(Variant variant) {
        this(variant, StatusCode.GOOD);
    }

    public DateTime getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void setServerTimestamp(DateTime dateTime) {
        this.serverTimestamp = dateTime;
    }

    public DateTime getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public void setSourceTimestamp(DateTime dateTime) {
        this.sourceTimestamp = dateTime;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusCode(UnsignedInteger unsignedInteger) {
        this.setStatusCode(new StatusCode(unsignedInteger));
    }

    public Variant getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value.getValue() == null;
    }

    public void setValue(Variant variant) {
        this.value = variant == null ? Variant.NULL : variant;
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.value) | ObjectUtils.hashCode(this.statusCode) | ObjectUtils.hashCode(this.sourceTimestamp) | ObjectUtils.hashCode(this.sourcePicoseconds) | ObjectUtils.hashCode(this.serverTimestamp) | ObjectUtils.hashCode(this.serverPicoseconds);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataValue)) {
            return false;
        }
        DataValue dataValue = (DataValue)object;
        return ObjectUtils.objectEquals(dataValue.value, this.value) && ObjectUtils.objectEquals(dataValue.statusCode, this.statusCode) && ObjectUtils.objectEquals(dataValue.sourceTimestamp, this.sourceTimestamp) && ObjectUtils.objectEquals(dataValue.serverTimestamp, this.serverTimestamp) && ObjectUtils.objectEquals(dataValue.sourcePicoseconds, this.sourcePicoseconds) && ObjectUtils.objectEquals(dataValue.serverPicoseconds, this.serverPicoseconds);
    }

    public UnsignedShort getSourcePicoseconds() {
        return this.sourcePicoseconds;
    }

    public void setSourcePicoseconds(UnsignedShort unsignedShort) {
        this.sourcePicoseconds = unsignedShort;
    }

    public UnsignedShort getServerPicoseconds() {
        return this.serverPicoseconds;
    }

    public void setServerPicoseconds(UnsignedShort unsignedShort) {
        this.serverPicoseconds = unsignedShort;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataValue(");
        stringBuilder.append("value=" + this.value);
        stringBuilder.append(", statusCode=" + this.statusCode);
        stringBuilder.append(", sourceTimestamp=" + this.sourceTimestamp);
        stringBuilder.append(", sourcePicoseconds=" + this.sourcePicoseconds);
        stringBuilder.append(", serverTimestamp=" + this.serverTimestamp);
        stringBuilder.append(", serverPicoseconds=" + this.serverPicoseconds);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Object clone() {
        return new DataValue(this.getValue(), this.getStatusCode(), this.getSourceTimestamp(), this.getServerPicoseconds(), this.getServerTimestamp(), this.getServerPicoseconds());
    }
}

