/*
 * Decompiled with CFR 0.152.
 */
package org.opcfoundation.ua.application;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.EndpointDiscoveryService;
import org.opcfoundation.ua.application.ServiceHandler;
import org.opcfoundation.ua.application.ServiceHandlerComposition;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.opcfoundation.ua.transport.Endpoint;
import org.opcfoundation.ua.transport.EndpointBinding;
import org.opcfoundation.ua.transport.EndpointServer;
import org.opcfoundation.ua.transport.UriUtil;
import org.opcfoundation.ua.transport.endpoint.EndpointBindingCollection;
import org.opcfoundation.ua.transport.https.HttpsServer;
import org.opcfoundation.ua.transport.security.CertificateValidator;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.transport.tcp.nio.OpcTcpServer;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static final String SOAP_XML_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/soaphttp-wssc-uaxml-uabinary";
    public static final String UATCP_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
    public static final String HTTPS_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
    static Logger logger = LoggerFactory.getLogger(Server.class);
    protected ServiceHandlerComposition serviceHandlers = new ServiceHandlerComposition();
    protected List<UserTokenPolicy> userTokenPolicies = new CopyOnWriteArrayList<UserTokenPolicy>();
    protected EndpointBindingCollection endpointBindings;
    protected EndpointDiscoveryService endpointDiscoveryService;
    protected Application application;
    protected List<EndpointServer.EndpointHandle> boundHandles = new CopyOnWriteArrayList<EndpointServer.EndpointHandle>();

    public static Server createServerApplication() {
        Application application = new Application();
        Server server = new Server(application);
        application.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        application.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        return server;
    }

    public Server(Application application) {
        this.application = application;
        this.endpointBindings = new EndpointBindingCollection();
        this.endpointDiscoveryService = new EndpointDiscoveryService(this.endpointBindings);
        this.addServiceHandler(this.endpointDiscoveryService);
    }

    public Application getApplication() {
        return this.application;
    }

    public ApplicationDescription createApplicationDescription() {
        ApplicationDescription applicationDescription = this.application.applicationDescription.clone();
        applicationDescription.setApplicationType(ApplicationType.Server);
        return applicationDescription;
    }

    public synchronized void setEndpointBindings(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
        this.endpointDiscoveryService.endpointBindings = endpointBindingCollection;
    }

    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    public void addServiceHandler(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null arg");
        }
        logger.debug("addServiceHandler: {}", object);
        if (logger.isTraceEnabled()) {
            logger.trace("addServiceHandler: from {}", (Object)Thread.currentThread().getStackTrace()[2]);
        }
        this.serviceHandlers.add(object);
    }

    public ServiceHandler[] getServiceHandlers() {
        return this.serviceHandlers.getServiceHandlers();
    }

    public <T> T getServiceHandlerByService(Class<? extends ServiceRequest> clazz) {
        return this.serviceHandlers.getServiceHandlerByService(clazz);
    }

    public boolean handlesService(Class<? extends IEncodeable> clazz) {
        return this.serviceHandlers.supportsService(clazz);
    }

    public ServiceHandlerComposition getServiceHandlerComposition() {
        return this.serviceHandlers;
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.add(userTokenPolicy);
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[0]);
    }

    public List<EndpointServer.EndpointHandle> bind(String string, Endpoint endpoint) throws ServiceResultException {
        ArrayList<EndpointServer.EndpointHandle> arrayList = new ArrayList<EndpointServer.EndpointHandle>();
        String string2 = UriUtil.getTransportProtocol(string);
        List<SocketAddress> list = EndpointUtil.toSocketAddresses(string);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        EndpointServer endpointServer = this.application.getOrCreateEndpointServer(string2);
        for (SocketAddress socketAddress : list) {
            EndpointBinding endpointBinding = new EndpointBinding(endpointServer, endpoint, this);
            EndpointServer.EndpointHandle endpointHandle = endpointServer.bind(socketAddress, endpointBinding);
            this.boundHandles.add(endpointHandle);
        }
        return arrayList;
    }

    public List<EndpointServer.EndpointHandle> bind(String string, String string2, SecurityMode ... securityModeArray) throws ServiceResultException {
        Endpoint endpoint = new Endpoint(string2, securityModeArray);
        return this.bind(string, endpoint);
    }

    public void close() {
        for (EndpointServer.EndpointHandle object2 : this.boundHandles) {
            logger.debug("unbind: {}", (Object)object2);
            object2.close();
        }
        this.boundHandles.clear();
        logger.info("Server {} closed", (Object)this);
        OpcTcpServer opcTcpServer = this.getApplication().opctcpServer;
        HttpsServer httpsServer = this.getApplication().httpsServer;
        if ((opcTcpServer == null || opcTcpServer.getEndpointBindings().isEmpty()) && (httpsServer == null || httpsServer.getEndpointBindings().isEmpty())) {
            this.getApplication().close();
        }
    }

    public Endpoint[] getEndpoints() {
        List<EndpointBinding> list = this.endpointBindings.get(this);
        List<Endpoint> list2 = EndpointBindingCollection.getEndpointAddresses(list);
        return list2.toArray(new Endpoint[list2.size()]);
    }

    public boolean hasEndpoint(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        return !list.isEmpty();
    }

    public Endpoint getEndpointByUri(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get((int)0).endpointAddress;
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.getEndpointDescriptions(null);
    }

    public EndpointDescription[] getEndpointDescriptions(SocketAddress socketAddress) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>(this.endpointBindings.size());
        UserTokenPolicy[] userTokenPolicyArray = this.getUserTokenPolicies();
        ApplicationDescription applicationDescription = this.createApplicationDescription();
        ArrayList<Endpoint> arrayList2 = new ArrayList<Endpoint>();
        if (socketAddress != null) {
            logger.trace("Server.getEndpointDescriptions: requestAddress=", (Object)socketAddress);
            for (EndpointServer object2 : this.endpointBindings.getEndpointServers()) {
                logger.trace("Server.getEndpointDescriptions: EndpointServer es=", (Object)object2);
                if (object2 instanceof OpcTcpServer) {
                    object = (OpcTcpServer)object2;
                    objectArray2 = ((OpcTcpServer)object).socketHandleSnapshot();
                    for (Object object3 : objectArray2) {
                        if (!socketAddress.equals(((OpcTcpServer.SocketHandle)object3).getSocketAddress())) continue;
                        for (Object object4 : objectArray = ((OpcTcpServer.SocketHandle)object3).endpointHandleSnapshot()) {
                            arrayList2.add(((OpcTcpServer.OpcTcpEndpointHandle)object4).endpointBinding().endpointAddress);
                        }
                    }
                }
                if (!(object2 instanceof HttpsServer)) continue;
                object = (HttpsServer)object2;
                objectArray2 = ((HttpsServer)object).socketHandleSnapshot();
                for (Object object5 : objectArray2) {
                    if (!socketAddress.equals(((HttpsServer.SocketHandle)object5).getSocketAddress())) continue;
                    for (Object object4 : objectArray = ((HttpsServer.SocketHandle)object5).endpointHandleSnapshot()) {
                        arrayList2.add(((HttpsServer.HttpsEndpointHandle)object4).endpointBinding().endpointAddress);
                    }
                }
            }
        }
        for (Endpoint endpoint : this.endpointBindings.getEndpointAddresses()) {
            if (socketAddress != null && !arrayList2.contains(endpoint)) continue;
            object = endpoint.getEndpointUrl();
            objectArray2 = UriUtil.getTransportProtocol((String)object).toLowerCase();
            for (KeyPair keyPair : this.application.getApplicationInstanceCertificates()) {
                objectArray = endpoint.getSecurityModes();
                logger.trace("getEndpointDescriptions: endpoint={}", (Object)endpoint);
                logger.trace("getEndpointDescriptions: keyPair={}", (Object)keyPair);
                if (logger.isTraceEnabled()) {
                    logger.trace("getEndpointDescriptions: securityModes={}", (Object)Arrays.toString(objectArray));
                }
                if ("https".equals(objectArray2)) {
                    objectArray = SecurityMode.NON_SECURE;
                } else if ("http".equals(objectArray2)) {
                    objectArray = SecurityMode.NON_SECURE;
                }
                for (Object object4 : objectArray) {
                    MessageSecurityMode messageSecurityMode = MessageSecurityMode.None;
                    String string = "";
                    String string2 = UATCP_BINARY_TRANSPORT_PROFILE_URI;
                    int n = 0;
                    if ("https".equals(objectArray2)) {
                        n = 2;
                        string = SecurityPolicy.NONE.getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("http".equals(objectArray2)) {
                        n = 0;
                        string = SecurityPolicy.NONE.getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("opc.tcp".equals(objectArray2)) {
                        messageSecurityMode = ((SecurityMode)object4).getMessageSecurityMode();
                        n = messageSecurityMode == MessageSecurityMode.None ? 0 : (messageSecurityMode == MessageSecurityMode.Sign ? 1 : (messageSecurityMode == MessageSecurityMode.SignAndEncrypt ? 2 : -1));
                        string = ((SecurityMode)object4).getSecurityPolicy().getPolicyUri();
                    }
                    if ((messageSecurityMode.hasEncryption() || messageSecurityMode.hasSigning()) && !((SecurityMode)object4).getSecurityPolicy().isUsableWith(keyPair.certificate)) continue;
                    EndpointDescription endpointDescription = new EndpointDescription();
                    endpointDescription.setEndpointUrl(endpoint.getEndpointUrl());
                    endpointDescription.setSecurityMode(messageSecurityMode);
                    endpointDescription.setSecurityLevel(UnsignedByte.valueOf(n));
                    endpointDescription.setSecurityPolicyUri(string);
                    endpointDescription.setServer(applicationDescription);
                    endpointDescription.setServerCertificate(keyPair.getCertificate().getEncoded());
                    endpointDescription.setTransportProfileUri(string2);
                    endpointDescription.setUserIdentityTokens(userTokenPolicyArray);
                    arrayList.add(endpointDescription);
                }
            }
        }
        logger.trace("getEndpointDescriptions: result={}" + arrayList);
        return arrayList.toArray(new EndpointDescription[0]);
    }

    public EndpointServer[] getBindings() {
        ArrayList<EndpointServer> arrayList = new ArrayList<EndpointServer>();
        for (EndpointBinding endpointBinding : this.endpointBindings.get(this)) {
            if (arrayList.contains(endpointBinding.endpointServer)) continue;
            arrayList.add(endpointBinding.endpointServer);
        }
        return arrayList.toArray(new EndpointServer[arrayList.size()]);
    }

    public String toString() {
        return "Server " + this.application.getApplicationUri();
    }
}

